/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSubModuleController
extends SubModuleController {
    private IActionRidget buttonRename;
    private ITableRidget table;
    private List<WordNode> input;

    public TableSubModuleController() {
        this(null);
    }

    public TableSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void afterBind() {
        super.afterBind();
        this.bindModel();
    }

    private void bindModel() {
        this.input = this.createInput();
        String[] columnPropertyNames = new String[]{"word", "upperCase", "ACount"};
        String[] columnHeaders = new String[]{"Word", "Uppercase", "A Count"};
        this.table.bindToModel((IObservableList)new WritableList(this.input, WordNode.class), WordNode.class, columnPropertyNames, columnHeaders);
        this.table.setComparator(0, (Comparator)new StringComparator());
        this.table.setComparator(1, (Comparator)new StringComparator());
        this.table.setColumnSortable(2, false);
        this.table.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.table.setSelection(0);
    }

    public void configureRidgets() {
        this.table = (ITableRidget)this.getRidget("table");
        IActionRidget buttonAddSibling = (IActionRidget)this.getRidget("buttonAddSibling");
        this.buttonRename = (IActionRidget)this.getRidget("buttonRename");
        IActionRidget buttonDelete = (IActionRidget)this.getRidget("buttonDelete");
        this.table.addDoubleClickListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TableSubModuleController.this.table.getSingleSelectionObservable().getValue();
                if (node != null) {
                    boolean isUpperCase = !node.isUpperCase();
                    node.setUpperCase(isUpperCase);
                }
            }
        });
        buttonAddSibling.setText("&Add");
        buttonAddSibling.addListener(new IActionListener(){

            public void callback() {
                WordNode newNode = new WordNode("A_NEW_SIBLING");
                TableSubModuleController.this.input.add(newNode);
                TableSubModuleController.this.table.updateFromModel();
                TableSubModuleController.this.table.setSelection((Object)newNode);
            }
        });
        this.buttonRename.setText("&Modify");
        this.buttonRename.addListener(new IActionListener(){

            public void callback() {
                String newValue;
                WordNode node = (WordNode)TableSubModuleController.this.table.getSingleSelectionObservable().getValue();
                if (node != null && (newValue = TableSubModuleController.this.getNewValue(node.getWordIgnoreUppercase())) != null) {
                    node.setWord(newValue);
                }
            }
        });
        buttonDelete.setText("&Delete");
        buttonDelete.addListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)TableSubModuleController.this.table.getSingleSelectionObservable().getValue();
                TableSubModuleController.this.input.remove(node);
                TableSubModuleController.this.table.updateFromModel();
            }
        });
        final IObservableValue viewerSelection = this.table.getSingleSelectionObservable();
        ComputedValue hasSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        this.bindEnablementToValue(dbc, (IMarkableRidget)buttonDelete, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IMarkableRidget)this.buttonRename, (IObservableValue)hasSelection);
    }

    private void bindEnablementToValue(DataBindingContext dbc, IMarkableRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private String getNewValue(Object oldValue) {
        String newValue = null;
        if (oldValue != null) {
            Shell shell = ((Button)this.buttonRename.getUIControl()).getShell();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    boolean isValid = newText.trim().length() > 0;
                    return isValid ? null : "Word cannot be empty!";
                }
            };
            InputDialog dialog = new InputDialog(shell, "Modify", "Enter a new word:", String.valueOf(oldValue), validator);
            int result = dialog.open();
            if (result == 0) {
                newValue = dialog.getValue();
            }
        }
        return newValue;
    }

    private List<WordNode> createInput() {
        String[] words = new String[]{"Adventure", "Acclimatisation", "Aardwark", "Binoculars", "Beverage", "Boredom", "Ballistics", "Calculation", "Coexistence", "Cinnamon", "Celebration", "Disney", "Dictionary", "Delta", "Desperate", "Elf", "Electronics", "Elwood", "Enemy"};
        ArrayList<WordNode> result = new ArrayList<WordNode>(words.length);
        int i = 0;
        while (i < words.length) {
            WordNode node = new WordNode(words[i]);
            result.add(node);
            ++i;
        }
        ((WordNode)result.get(0)).setUpperCase(true);
        ((WordNode)result.get(1)).setUpperCase(true);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Comparator<Object>,
    Serializable {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

