/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.views;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.example.client.controllers.MarkerSubModuleController;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerSubModuleView
extends SubModuleView<MarkerSubModuleController> {
    public static final String ID = MarkerSubModuleView.class.getName();

    protected void basicCreatePartControl(Composite parent) {
        parent.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
        parent.setLayout((Layout)new GridLayout(2, false));
        Group group1 = this.createMarkerOptionsGroup(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group1);
        Group group2 = this.createVisibilityOptionsGroup(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group2);
        Group group3 = this.createControlsGroup(parent);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)group3);
    }

    private Group createMarkerOptionsGroup(Composite parent) {
        Group group = UIControlsFactory.createGroup((Composite)parent, (String)"Marker Options:");
        group.setLayout((Layout)this.createFillLayout());
        Button checkMandatory = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkMandatory, "checkMandatory");
        Button checkError = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkError, "checkError");
        Button checkDisabled = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkDisabled, "checkDisabled");
        Button checkOutput = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkOutput, "checkOutput");
        return group;
    }

    private Group createVisibilityOptionsGroup(Composite parent) {
        Group group = UIControlsFactory.createGroup((Composite)parent, (String)"Visibility Options:");
        group.setLayout((Layout)this.createFillLayout());
        Button checkHidden = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkHidden, "checkHidden");
        return group;
    }

    private Group createControlsGroup(Composite parent) {
        Group group = UIControlsFactory.createGroup((Composite)parent, (String)"UI-Controls:");
        int defaultVSpacing = new GridLayout().verticalSpacing;
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(20, 20).spacing(10, defaultVSpacing).applyTo((Composite)group);
        GridDataFactory hFillFactory = GridDataFactory.fillDefaults().grab(true, false);
        UIControlsFactory.createLabel((Composite)group, (String)"Name:");
        Text textName = UIControlsFactory.createText((Composite)group);
        hFillFactory.applyTo((Control)textName);
        this.addUIControl(textName, "textName");
        UIControlsFactory.createLabel((Composite)group, (String)"Price:");
        Text textPrice = UIControlsFactory.createTextDecimal((Composite)group);
        hFillFactory.applyTo((Control)textPrice);
        this.addUIControl(textPrice, "textPrice");
        UIControlsFactory.createLabel((Composite)group, (String)"Age:");
        Combo comboAge = UIControlsFactory.createCombo((Composite)group);
        hFillFactory.applyTo((Control)comboAge);
        this.addUIControl(comboAge, "comboAge");
        UIControlsFactory.createLabel((Composite)group, (String)"Type:");
        ChoiceComposite choiceType = new ChoiceComposite((Composite)group, 2048, false);
        choiceType.setOrientation(256);
        this.addUIControl(choiceType, "choiceType");
        UIControlsFactory.createLabel((Composite)group, (String)"Flavor:");
        ChoiceComposite choiceFlavor = new ChoiceComposite((Composite)group, 2048, true);
        choiceFlavor.setOrientation(256);
        this.addUIControl(choiceFlavor, "choiceFlavor");
        Label lblReviewed = UIControlsFactory.createLabel((Composite)group, (String)"Reviewed by:");
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)lblReviewed);
        Composite composite = this.createComposite(group);
        List listPersons = UIControlsFactory.createList((Composite)composite, (boolean)false, (boolean)true);
        int hHint = UIControlsFactory.getHeightHint((List)listPersons, (int)5);
        hFillFactory.hint(150, hHint).applyTo((Control)listPersons);
        this.addUIControl(listPersons, "listPersons");
        Table tablePersons = new Table(composite, 68096);
        tablePersons.setLinesVisible(true);
        tablePersons.setHeaderVisible(true);
        TableColumn tac1 = new TableColumn(tablePersons, 0);
        tac1.setWidth(100);
        TableColumn tac2 = new TableColumn(tablePersons, 0);
        tac2.setWidth(70);
        hFillFactory.hint(170, hHint).applyTo((Control)tablePersons);
        this.addUIControl(tablePersons, "tablePersons");
        Tree treePersons = new Tree(composite, 68096);
        hFillFactory.hint(150, hHint).applyTo((Control)treePersons);
        this.addUIControl(treePersons, "treePersons");
        Tree treeWCols = new Tree(composite, 68098);
        treeWCols.setLinesVisible(true);
        treeWCols.setHeaderVisible(true);
        TreeColumn trc1 = new TreeColumn(treeWCols, 0);
        trc1.setWidth(120);
        TreeColumn trc2 = new TreeColumn(treeWCols, 0);
        trc2.setWidth(40);
        hFillFactory.hint(200, hHint).applyTo((Control)treeWCols);
        this.addUIControl(treeWCols, "treeWCols");
        UIControlsFactory.createLabel((Composite)group, (String)"Buttons:");
        composite = this.createComposite(group);
        Button buttonToggle = UIControlsFactory.createButtonToggle((Composite)composite);
        this.addUIControl(buttonToggle, "buttonToggle");
        Button buttonPush = UIControlsFactory.createButton((Composite)composite);
        buttonPush.setText("Push");
        this.addUIControl(buttonPush, "buttonPush");
        Button buttonRadioA = UIControlsFactory.createButtonRadio((Composite)composite);
        buttonRadioA.setText("Radio A");
        this.addUIControl(buttonRadioA, "buttonRadioA");
        Button buttonRadioB = UIControlsFactory.createButtonRadio((Composite)composite);
        buttonRadioB.setText("Radio B");
        this.addUIControl(buttonRadioB, "buttonRadioB");
        Button buttonCheck = UIControlsFactory.createButtonCheck((Composite)composite);
        buttonCheck.setText("Check");
        this.addUIControl(buttonCheck, "buttonCheck");
        return group;
    }

    private Composite createComposite(Group group) {
        Composite composite = new Composite((Composite)group, 0);
        composite.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
        GridLayoutFactory.fillDefaults().numColumns(5).equalWidth(false).spacing(10, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        return composite;
    }

    private FillLayout createFillLayout() {
        FillLayout layout = new FillLayout(256);
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        return layout;
    }
}

