/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.riena.ui.swt.ModuleTitleBar;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.EmbeddedTitlebarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class ModuleToolTip
extends DefaultToolTip {
    private ModuleTitleBar titleBar;

    public ModuleToolTip(ModuleTitleBar titleBar) {
        super((Control)titleBar);
        this.setTitleBar(titleBar);
        this.setShift(new Point(0, 0));
    }

    private void initLookAndFeel() {
        Color color;
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Integer delay = lnf.getIntegerSetting("ModuleItemToolTip.popupDelay");
        if (delay != null) {
            this.setPopupDelay(delay);
        }
        if ((color = lnf.getColor("ModuleItemToolTip.foreground")) != null) {
            this.setForegroundColor(color);
        }
        if ((color = lnf.getColor("ModuleItemToolTip.background")) != null) {
            this.setBackgroundColor(color);
        }
        Font font = lnf.getFont("ModuleItemToolTip.font");
        if (color != null) {
            this.setFont(font);
        }
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        CLabel label = new CLabel(parent, this.getStyle(event));
        Color fgColor = this.getForegroundColor(event);
        Color bgColor = this.getBackgroundColor(event);
        Font font = this.getFont(event);
        if (fgColor != null) {
            label.setForeground(fgColor);
        }
        if (bgColor != null) {
            label.setBackground(bgColor);
        }
        if (font != null) {
            label.setFont(font);
        }
        label.setText(this.getTitleBar().getTitle());
        return label;
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean should = super.shouldCreateToolTip(event);
        if (should) {
            this.initLookAndFeel();
            should = this.getTitleBar().isTextClipped();
        }
        return should;
    }

    public Point getLocation(Point tipSize, Event event) {
        GC gc = new GC((Drawable)this.getTitleBar());
        Rectangle bounds = this.getLnfTitlebarRenderer().computeTextBounds(gc);
        Point location = this.getTitleBar().toDisplay(bounds.x, 0);
        gc.dispose();
        return location;
    }

    private EmbeddedTitlebarRenderer getLnfTitlebarRenderer() {
        EmbeddedTitlebarRenderer renderer = (EmbeddedTitlebarRenderer)LnfManager.getLnf().getRenderer("SubModuleView.titlebarRenderer");
        if (renderer == null) {
            renderer = new EmbeddedTitlebarRenderer();
        }
        return renderer;
    }

    private void setTitleBar(ModuleTitleBar titleBar) {
        this.titleBar = titleBar;
    }

    private ModuleTitleBar getTitleBar() {
        return this.titleBar;
    }
}

