/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleGroupRenderer
extends AbstractLnfRenderer {
    private static final int MODULE_MODULE_GAP = 2;
    private static final int MODULE_GROUP_PADDING = 1;
    private static final int MODULE_WIDTH = 165;
    private List<ModuleView> items;

    public void paint(GC gc, Object value) {
        Point size = this.computeSize(gc, this.getBounds().width, 0);
        EmbeddedBorderRenderer borderRenderer = this.getLnfBorderRenderer();
        borderRenderer.setMarkers(this.getMarkers());
        borderRenderer.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, size.y);
        borderRenderer.setActive(true);
        borderRenderer.paint(gc, null);
    }

    public void dispose() {
        for (ModuleView item : this.getItems()) {
            item.dispose();
        }
    }

    public Point computeSize(GC gc, int wHint, int hHint) {
        EmbeddedBorderRenderer borderRenderer = this.getLnfBorderRenderer();
        int w = wHint;
        if (w == -1) {
            w = borderRenderer.computeOuterWidth(this.getItemWidth());
        }
        List<ModuleView> modules = this.getItems();
        int h = 0;
        if (modules.size() > 0) {
            h = this.getModuleGroupPadding();
            Iterator<ModuleView> iterator = modules.iterator();
            while (iterator.hasNext()) {
                ModuleView moduleView = iterator.next();
                moduleView.updateModuleView();
                h += moduleView.getBounds().height;
                if (iterator.hasNext()) {
                    h += this.getModuleModuleGap();
                    continue;
                }
                h += this.getModuleGroupPadding();
            }
            h = borderRenderer.computeOuterHeight(h);
        }
        return new Point(w, h);
    }

    private EmbeddedBorderRenderer getLnfBorderRenderer() {
        EmbeddedBorderRenderer renderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.borderRenderer");
        if (renderer == null) {
            renderer = new EmbeddedBorderRenderer();
        }
        return renderer;
    }

    public List<ModuleView> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<ModuleView>();
        }
        return this.items;
    }

    public void setItems(List<ModuleView> items) {
        this.items = items;
    }

    public int getModuleModuleGap() {
        return 2;
    }

    public int getModuleGroupPadding() {
        return 1;
    }

    public int getItemWidth() {
        return 165;
    }
}

