/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.IApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellLogoRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProviderAccessor;
import org.eclipse.riena.navigation.ui.swt.presentation.stack.TitlelessStackPresentation;
import org.eclipse.riena.navigation.ui.swt.views.GrabCorner;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewPart;
import org.eclipse.riena.navigation.ui.swt.views.SubApplicationSwitcherViewPart;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.swt.AbstractTitleBarMouseListener;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineSpacer;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageUtil;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ApplicationViewAdvisor
extends WorkbenchWindowAdvisor {
    private static final Logger LOGGER = Activator.getDefault().getLogger(ApplicationViewAdvisor.class);
    private static final String PROPERTY_RIENA_APPLICATION_WIDTH = "riena.application.width";
    private static final String PROPERTY_RIENA_APPLICATION_HEIGHT = "riena.application.height";
    public static final int STATUSLINE_HEIGHT = 22;
    private static final Point APPLICATION_MIN_SIZE = new Point(800, 600);
    private static final int COOLBAR_TOP_MARGIN = 2;
    public static final String SHELL_RIDGET_PROPERTY = "applicationWindow";
    private ApplicationController controller;
    private AbstractViewBindingDelegate binding;
    private Composite switcherComposite;
    private TitlelessShellMouseListener mouseListener;

    public ApplicationViewAdvisor(IWorkbenchWindowConfigurer configurer, ApplicationController pController) {
        super(configurer);
        this.controller = pController;
        this.binding = this.createBinding();
        this.initializeListener();
    }

    public void addUIControl(Composite control, String propertyName) {
        this.binding.addUIControl((Object)control, propertyName);
    }

    private void initializeListener() {
        MySubApplicationNodeListener subApplicationListener = new MySubApplicationNodeListener();
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubApplicationNodeListener)subApplicationListener);
        navigationTreeObserver.addListener((IApplicationNodeListener)new MyApplicationNodeListener());
        navigationTreeObserver.addListenerTo((IApplicationNode)this.controller.getNavigationNode());
    }

    public void preWindowOpen() {
        this.configureWindow();
    }

    private void configureWindow() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setTitle(((IApplicationNode)this.controller.getNavigationNode()).getLabel());
        this.initApplicationSize(configurer);
        if (LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue()) {
            configurer.setShellStyle(0x20000008);
        }
    }

    private void initApplicationSize(IWorkbenchWindowConfigurer configurer) {
        int width = ApplicationViewAdvisor.APPLICATION_MIN_SIZE.x;
        String widthStrg = System.getProperty(PROPERTY_RIENA_APPLICATION_WIDTH);
        if (!StringUtils.isEmpty((CharSequence)widthStrg)) {
            width = Integer.parseInt(widthStrg);
        }
        if (width < ApplicationViewAdvisor.APPLICATION_MIN_SIZE.x) {
            width = ApplicationViewAdvisor.APPLICATION_MIN_SIZE.x;
            String message = "The initial width of the application is less than the minimum width!";
            LOGGER.log(2, message);
        }
        int height = ApplicationViewAdvisor.APPLICATION_MIN_SIZE.y;
        String heightStrg = System.getProperty(PROPERTY_RIENA_APPLICATION_HEIGHT);
        if (!StringUtils.isEmpty((CharSequence)heightStrg)) {
            height = Integer.parseInt(heightStrg);
        }
        if (height < ApplicationViewAdvisor.APPLICATION_MIN_SIZE.y) {
            height = ApplicationViewAdvisor.APPLICATION_MIN_SIZE.y;
            String message = "The initial height of the application is less than the minimum height!";
            LOGGER.log(2, message);
        }
        configurer.setInitialSize(new Point(width, height));
    }

    public void postWindowOpen() {
        if (this.switcherComposite != null) {
            this.switcherComposite.setRedraw(false);
            this.switcherComposite.setRedraw(true);
        }
        super.postWindowOpen();
        this.doInitialBinding();
    }

    private void doInitialBinding() {
        this.binding.injectAndBind((IController)this.controller);
        this.controller.afterBind();
        ((IApplicationNode)this.controller.getNavigationNode()).activate();
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new InjectSwtViewBindingDelegate();
    }

    public void dispose() {
        super.dispose();
        if (this.mouseListener != null) {
            this.mouseListener.dispose();
            this.mouseListener = null;
        }
    }

    public void createWindowContents(Shell shell) {
        this.initShell(shell);
        shell.setLayout((Layout)new FormLayout());
        GrabCorner grabCorner = this.createGrabCorner(shell);
        this.createStatusLine((Composite)shell, grabCorner);
        Composite titleComposite = this.createTitleComposite((Composite)shell);
        Composite menuBarComposite = this.createMenuBarComposite((Composite)shell, titleComposite);
        Composite coolBarComposite = this.createCoolBarComposite((Composite)shell, menuBarComposite);
        this.createMainComposite((Composite)shell, coolBarComposite);
    }

    private void createStatusLine(Composite shell, Composite grabCorner) {
        Statusline statusLine = new Statusline(shell, 0, StatuslineSpacer.class);
        FormData fd = new FormData();
        fd.height = 22;
        Rectangle navigationBounds = TitlelessStackPresentation.calcNavigationBounds(shell);
        fd.left = new FormAttachment(0, navigationBounds.x + navigationBounds.width + 2);
        fd.right = new FormAttachment((Control)grabCorner, 0);
        fd.bottom = new FormAttachment(100, -5);
        statusLine.setLayoutData((Object)fd);
        this.addUIControl((Composite)statusLine, "statuslineRidget");
    }

    private void initShell(Shell shell) {
        shell.setBackground(LnfManager.getLnf().getColor("TitlelessShell.background"));
        shell.addPaintListener((PaintListener)new ShellPaintListener());
        shell.setImage(ImageUtil.getImage((String)((IApplicationNode)this.controller.getNavigationNode()).getIcon()));
        shell.setMinimumSize(APPLICATION_MIN_SIZE);
        this.addUIControl((Composite)shell, SHELL_RIDGET_PROPERTY);
        if (this.getShellRenderer() != null) {
            this.getShellRenderer().setShell(shell);
        }
    }

    private MenuManager getMenuManager() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWindowConfigurer().getWindow();
        return workbenchWindow.getMenuManager();
    }

    private int getSwitchterTopMargin() {
        int margin = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.topMargin");
        return margin;
    }

    private int getSwitchterHeight() {
        int margin = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.height");
        return margin;
    }

    private Composite createTitleComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setBackgroundMode(2);
        Image image = LnfManager.getLnf().getImage("TitlelessShell.backgroundImage");
        result.setBackgroundImage(image);
        result.setLayout((Layout)new FormLayout());
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        int borderWidth = borderRenderer.getBorderWidth();
        FormData data = new FormData();
        data.top = new FormAttachment((Control)parent, borderWidth);
        data.left = new FormAttachment(0, borderWidth);
        data.right = new FormAttachment(100, -borderWidth);
        result.setLayoutData((Object)data);
        this.createLogoComposite(result);
        this.switcherComposite = this.createSwitcherComposite(result);
        result.addPaintListener((PaintListener)new TitlelessPaintListener());
        this.mouseListener = new TitlelessShellMouseListener();
        result.addMouseListener((MouseListener)this.mouseListener);
        result.addMouseMoveListener((MouseMoveListener)this.mouseListener);
        result.addMouseTrackListener((MouseTrackListener)this.mouseListener);
        return result;
    }

    private void createLogoComposite(Composite parent) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        Composite logoComposite = new Composite(parent, 0x20000000);
        FormData logoData = new FormData();
        int topInset = 4;
        int leftRightInset = 12;
        logoData.top = new FormAttachment(0, topInset);
        int height = this.getSwitchterTopMargin() + this.getSwitchterHeight() - 1;
        logoData.bottom = new FormAttachment(0, height);
        Image logoImage = this.getLogoImage();
        if (logoImage == null) {
            return;
        }
        ImageData imageData = logoImage.getImageData();
        if (imageData == null) {
            return;
        }
        logoData.width = imageData.width + ShellLogoRenderer.getHorizontalLogoMargin() * 2;
        Integer hPos = this.getHorizontalLogoPosition();
        switch (hPos) {
            case 0x1000000: {
                logoData.left = new FormAttachment(50, -logoData.width / 2);
                break;
            }
            case 131072: {
                logoData.right = new FormAttachment(100, -leftRightInset);
                break;
            }
            default: {
                logoData.left = new FormAttachment(0, leftRightInset);
            }
        }
        logoComposite.setLayoutData((Object)logoData);
        logoComposite.addPaintListener((PaintListener)new LogoPaintListener());
    }

    private GrabCorner createGrabCorner(Shell shell) {
        if (GrabCorner.isResizeable() && LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue()) {
            return new GrabCorner(shell, 0x20000000);
        }
        return null;
    }

    private Composite createSwitcherComposite(Composite parent) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        Composite composite = new Composite(parent, 0x20000000);
        composite.setLayout((Layout)new FillLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, this.getSwitchterTopMargin() + padding);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = this.getSwitchterHeight();
        composite.setLayoutData((Object)formData);
        ApplicationNode node = (ApplicationNode)this.controller.getNavigationNode();
        SubApplicationSwitcherViewPart switcherViewPart = new SubApplicationSwitcherViewPart(node);
        switcherViewPart.createPartControl(composite);
        return composite;
    }

    private Composite createMenuBarComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        MenuCoolBarComposite composite = new MenuCoolBarComposite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.createMenuBar(composite);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous, 2);
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        composite.setLayoutData(formData);
        return composite;
    }

    private void createMenuBar(MenuCoolBarComposite parent) {
        IContributionItem[] contribItems = this.getMenuManager().getItems();
        int i = 0;
        while (i < contribItems.length) {
            if (contribItems[i] instanceof MenuManager) {
                MenuManager topMenuManager = (MenuManager)contribItems[i];
                parent.createAndAddMenu(topMenuManager);
            }
            ++i;
        }
    }

    private Composite createCoolBarComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getCoolBarSeparatorPadding();
        Label separator = new Label(parent, 258);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous);
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        separator.setLayoutData((Object)formData);
        padding = this.getShellPadding();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        formData = new FormData();
        formData.top = new FormAttachment((Control)previous, 2);
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        composite.setLayoutData((Object)formData);
        Control control = this.getWindowConfigurer().createCoolBarControl(composite);
        if (control instanceof CoolBar) {
            CoolBar coolbar = (CoolBar)control;
            MenuCoolBarComposite.initCoolBar(coolbar);
        }
        return composite;
    }

    private int getCoolBarSeparatorPadding() {
        ModuleGroupRenderer mgRenderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (mgRenderer == null) {
            mgRenderer = new ModuleGroupRenderer();
        }
        int padding = mgRenderer.getModuleGroupPadding();
        EmbeddedBorderRenderer borderRenderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.borderRenderer");
        if (borderRenderer == null) {
            borderRenderer = new EmbeddedBorderRenderer();
        }
        padding += borderRenderer.getBorderWidth();
        return padding += this.getShellPadding();
    }

    private Composite createMainComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        Composite composite = new Composite(parent, 0x20000000);
        composite.setLayout((Layout)new FillLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous, 0, 0);
        formData.bottom = new FormAttachment(100, -padding);
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        composite.setLayoutData((Object)formData);
        this.getWindowConfigurer().createPageComposite(composite);
        return composite;
    }

    private int getShellPadding() {
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        return borderRenderer.getCompleteBorderWidth();
    }

    private Image getLogoImage() {
        return LnfManager.getLnf().getImage("TitlelessShell.logo");
    }

    private int getHorizontalLogoPosition() {
        Integer hPos = LnfManager.getLnf().getIntegerSetting("TitlelessShell.horizontalLogoPosition");
        if (hPos == null) {
            hPos = 16384;
        }
        return hPos;
    }

    private ShellRenderer getShellRenderer() {
        ShellRenderer shellRenderer = (ShellRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.renderer");
        return shellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BtnState {
        NONE,
        HOVER,
        HOVER_SELECTED;

    }

    private static class LogoPaintListener
    implements PaintListener {
        private LogoPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            Composite logoComposite = (Composite)e.getSource();
            Rectangle compositeBounds = logoComposite.getBounds();
            ShellLogoRenderer renderer = (ShellLogoRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.logoRenderer");
            renderer.setBounds(compositeBounds);
            renderer.paint(e.gc, null);
        }
    }

    private static class MyApplicationNodeListener
    extends ApplicationNodeListener {
        private MyApplicationNodeListener() {
        }

        public void filterAdded(IApplicationNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            try {
                NavigationViewPart navi = (NavigationViewPart)this.getActivePage().showView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart");
                navi.updateNavigationSize();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }

        private IWorkbenchPage getActivePage() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }

        public void filterRemoved(IApplicationNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            try {
                NavigationViewPart navi = (NavigationViewPart)this.getActivePage().showView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart");
                navi.updateNavigationSize();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private class MySubApplicationNodeListener
    extends SubApplicationNodeListener {
        private MySubApplicationNodeListener() {
        }

        public void activated(ISubApplicationNode source) {
            if (source != null) {
                this.showPerspective(source);
                ApplicationViewAdvisor.this.switcherComposite.setRedraw(false);
                ApplicationViewAdvisor.this.switcherComposite.setRedraw(true);
            }
            super.activated((INavigationNode)source);
        }

        private void showPerspective(ISubApplicationNode source) {
            try {
                PlatformUI.getWorkbench().showPerspective(SwtViewProviderAccessor.getViewProvider().getSwtViewId((INavigationNode<?>)source).getId(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
        }
    }

    private static class ShellPaintListener
    implements PaintListener {
        private ShellPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control shell = (Control)e.getSource();
                Rectangle shellBounds = shell.getBounds();
                Rectangle bounds = new Rectangle(0, 0, shellBounds.width, shellBounds.height);
                ILnfRenderer borderRenderer = LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
                borderRenderer.setBounds(bounds);
                borderRenderer.paint(e.gc, null);
            }
        }
    }

    private class TitlelessPaintListener
    implements PaintListener {
        private TitlelessPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control shell = (Control)e.getSource();
                ShellRenderer shellRenderer = ApplicationViewAdvisor.this.getShellRenderer();
                Rectangle shellBounds = shell.getBounds();
                Rectangle bounds = new Rectangle(0, 0, shellBounds.width, shellRenderer.getHeight());
                shellRenderer.setBounds(bounds);
                RienaDefaultLnf lnf = LnfManager.getLnf();
                shellRenderer.setCloseable(lnf.getBooleanSetting("TitlelessShell.showClose"));
                shellRenderer.setMaximizable(lnf.getBooleanSetting("TitlelessShell.showMax"));
                shellRenderer.setMinimizable(lnf.getBooleanSetting("TitlelessShell.showMin"));
                shellRenderer.paint(e.gc, shell);
            }
        }
    }

    private class TitlelessShellMouseListener
    extends AbstractTitleBarMouseListener {
        private TitlelessShellMouseListener() {
        }

        protected AbstractTitleBarRenderer getTitleBarRenderer() {
            return ApplicationViewAdvisor.this.getShellRenderer();
        }
    }
}

