/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.ui.swt.views.GrabCorner;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Widget;

public final class GrabCornerListenerWithTracker
extends MouseAdapter
implements MouseTrackListener {
    private final GrabCorner control;
    private Cursor resizeCursor;
    private Cursor defaultCursor;

    public GrabCornerListenerWithTracker(GrabCorner control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwtUtilities.disposeResource((Resource)GrabCornerListenerWithTracker.this.resizeCursor);
                SwtUtilities.disposeResource((Resource)GrabCornerListenerWithTracker.this.defaultCursor);
            }
        });
        control.addMouseListener((MouseListener)this);
        control.addMouseTrackListener(this);
        this.control = control;
    }

    public void mouseDown(MouseEvent e) {
        Tracker tracker = this.createTracker();
        try {
            boolean doResize = tracker.open();
            if (doResize) {
                this.handleResize(tracker);
            }
        }
        finally {
            SwtUtilities.disposeWidget((Widget)tracker);
        }
    }

    public void mouseEnter(MouseEvent e) {
        this.showResizeCursor();
    }

    public void mouseExit(MouseEvent e) {
        this.showDefaultCursor();
    }

    public void mouseHover(MouseEvent e) {
    }

    private void showResizeCursor() {
        if (this.resizeCursor == null) {
            this.resizeCursor = new Cursor((Device)this.control.getDisplay(), 8);
        }
        this.control.setCursor(this.resizeCursor);
    }

    private void showDefaultCursor() {
        if (this.defaultCursor == null) {
            this.defaultCursor = new Cursor((Device)this.control.getDisplay(), 0);
        }
        this.control.setCursor(this.defaultCursor);
    }

    private Tracker createTracker() {
        Shell shell = this.control.getShell();
        Display display = shell.getDisplay();
        Tracker tracker = new Tracker(display, 132112);
        tracker.addControlListener((ControlListener)new TrackerListener());
        Rectangle boundsDsp = display.map((Control)shell, null, shell.getClientArea());
        tracker.setRectangles(new Rectangle[]{boundsDsp});
        tracker.setStippled(true);
        return tracker;
    }

    private void handleResize(Tracker tracker) {
        Rectangle bounds = this.getTrackerBounds(tracker);
        if (bounds != null) {
            this.control.getShell().setBounds(bounds);
        }
    }

    private Rectangle getTrackerBounds(Tracker tracker) {
        Rectangle[] rectangles = tracker.getRectangles();
        if (rectangles.length > 0) {
            return rectangles[0];
        }
        return null;
    }

    private void setMinimumBounds(Tracker tracker) {
        Rectangle bounds = this.getTrackerBounds(tracker);
        Point miniSize = this.control.getShell().getMinimumSize();
        boolean setTrackerBounds = false;
        if (bounds.width < miniSize.x) {
            setTrackerBounds = true;
            bounds.width = miniSize.x;
        }
        if (bounds.height < miniSize.y) {
            setTrackerBounds = true;
            bounds.height = miniSize.y;
        }
        if (setTrackerBounds) {
            tracker.setRectangles(new Rectangle[]{bounds});
        }
    }

    private class TrackerListener
    implements ControlListener {
        private TrackerListener() {
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (e.widget instanceof Tracker) {
                Tracker tracker = (Tracker)e.widget;
                GrabCornerListenerWithTracker.this.setMinimumBounds(tracker);
            }
        }
    }
}

