/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleGroupView
extends Composite
implements INavigationNodeView<IController, ModuleGroupNode> {
    private static final int MODULE_GROUP_GAP = 3;
    private ModuleGroupNode moduleGroupNode;
    private ModuleGroupListener moduleGroupListener;
    private ModuleListener moduleListener;
    private PaintDelegation paintDelegation;
    private List<IComponentUpdateListener> updateListeners = new ArrayList<IComponentUpdateListener>();
    private Map<ModuleNode, ModuleView> registeredModuleViews = new LinkedHashMap<ModuleNode, ModuleView>();

    public ModuleGroupView(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.setData(this.getClass().getName());
    }

    private List<ModuleView> getAllModuleViews() {
        return new ArrayList<ModuleView>(this.registeredModuleViews.values());
    }

    private List<ModuleView> getAllVisibleModuleViews() {
        ArrayList<ModuleView> views = new ArrayList<ModuleView>();
        for (ModuleView view : this.registeredModuleViews.values()) {
            if (!view.isVisible()) continue;
            views.add(view);
        }
        return views;
    }

    protected ModuleNode getNodeForView(ModuleView view) {
        for (ModuleNode node : this.registeredModuleViews.keySet()) {
            ModuleView moduleView = this.registeredModuleViews.get(node);
            if (!moduleView.equals(view)) continue;
            return node;
        }
        return null;
    }

    @Override
    public void bind(ModuleGroupNode node) {
        this.moduleGroupNode = node;
        this.addListeners();
    }

    protected void addListeners() {
        this.moduleGroupListener = new ModuleGroupListener();
        this.getNavigationNode().addListener((INavigationNodeListener)this.moduleGroupListener);
        this.moduleListener = new ModuleListener();
        this.paintDelegation = new PaintDelegation();
        this.addPaintListener(this.paintDelegation);
    }

    @Override
    public void unbind() {
        this.getNavigationNode().removeListener((INavigationNodeListener)this.moduleGroupListener);
        this.removePaintListener(this.paintDelegation);
        this.moduleGroupNode = null;
    }

    @Override
    public ModuleGroupNode getNavigationNode() {
        return this.moduleGroupNode;
    }

    public int calculateBounds(int positionHint) {
        if (this.isDisposed()) {
            return 0;
        }
        Point p = new Point(0, 0);
        if (this.getNavigationNode() != null && this.getNavigationNode().isVisible()) {
            p = this.computeSize(-1, -1);
        }
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, positionHint);
        fd.left = new FormAttachment(0, 0);
        fd.width = p.x;
        fd.bottom = new FormAttachment(0, positionHint += p.y);
        this.setLayoutData(fd);
        this.layout();
        this.update();
        if (p.y > 0) {
            positionHint += 3;
        }
        return positionHint;
    }

    public Point computeSize(int wHint, int hHint) {
        GC gc = new GC((Drawable)Display.getCurrent());
        this.getRenderer().setItems(this.getAllVisibleModuleViews());
        Point size = this.getRenderer().computeSize(gc, wHint, hHint);
        gc.dispose();
        return size;
    }

    private ModuleGroupRenderer getRenderer() {
        return (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
    }

    public void registerModuleView(ModuleView moduleView) {
        moduleView.getNavigationNode().addListener((INavigationNodeListener)this.moduleListener);
        this.registeredModuleViews.put(moduleView.getNavigationNode(), moduleView);
        moduleView.addUpdateListener(new ModuleViewObserver());
    }

    public void unregisterModuleView(IModuleNode moduleNode) {
        for (ModuleView moduleView : this.getAllModuleViews()) {
            if (moduleView.getNavigationNode() != moduleNode && moduleView.getNavigationNode() != null) continue;
            this.unregisterModuleView(moduleView);
            break;
        }
    }

    public void unregisterModuleView(ModuleView moduleView) {
        ModuleNode node = this.getNodeForView(moduleView);
        node.removeListener((INavigationNodeListener)this.moduleListener);
        this.registeredModuleViews.remove(node);
    }

    protected void fireUpdated(INavigationNode<?> node) {
        for (IComponentUpdateListener listener : this.updateListeners) {
            listener.update(node);
        }
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    private final class ModuleGroupListener
    extends ModuleGroupNodeListener {
        private ModuleGroupListener() {
        }

        public void filterAdded(IModuleGroupNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void filterRemoved(IModuleGroupNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void childAdded(IModuleGroupNode source, IModuleNode child) {
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void childRemoved(IModuleGroupNode source, IModuleNode child) {
            ModuleGroupView.this.unregisterModuleView(child);
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void deactivated(IModuleGroupNode source) {
            super.deactivated((INavigationNode)source);
            ModuleGroupView.this.redraw();
        }

        public void disposed(IModuleGroupNode source) {
            super.disposed((INavigationNode)source);
            ModuleGroupView.this.unbind();
            ModuleGroupView.this.dispose();
        }
    }

    private final class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void childAdded(IModuleNode source, ISubModuleNode child) {
            super.childAdded((INavigationNode)source, (INavigationNode)child);
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void childRemoved(IModuleNode source, ISubModuleNode child) {
            super.childRemoved((INavigationNode)source, (INavigationNode)child);
            ModuleGroupView.this.fireUpdated((INavigationNode<?>)child);
        }

        public void filterAdded(IModuleNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }

        public void filterRemoved(IModuleNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            ModuleGroupView.this.fireUpdated(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModuleViewObserver
    implements IComponentUpdateListener {
        private ModuleViewObserver() {
        }

        @Override
        public void update(INavigationNode<?> node) {
            ModuleGroupView.this.fireUpdated(node);
        }
    }

    private class PaintDelegation
    implements PaintListener {
        private PaintDelegation() {
        }

        public void paintControl(PaintEvent e) {
            ModuleGroupView.this.setBackground(LnfManager.getLnf().getColor("ModuleGroupWidget.background"));
            ModuleGroupView.this.getRenderer().setMarkers(ModuleGroupView.this.getNavigationNode().getMarkers());
            ModuleGroupView.this.getRenderer().setItems(ModuleGroupView.this.getAllVisibleModuleViews());
            Point size = ModuleGroupView.this.getRenderer().computeSize(e.gc, -1, -1);
            ModuleGroupView.this.getRenderer().setBounds(0, 0, size.x, size.y);
            ModuleGroupView.this.getRenderer().paint(e.gc, null);
        }
    }
}

