/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.component.ModuleToolTip;
import org.eclipse.riena.navigation.ui.swt.component.SubModuleToolTip;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleTreeItemMarkerRenderer;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.swt.ModuleTitleBar;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleView
implements INavigationNodeView<SWTModuleController, ModuleNode> {
    private static final String WINDOW_RIDGET = "windowRidget";
    private AbstractViewBindingDelegate binding;
    private Composite parent;
    private Composite body;
    private Tree subModuleTree;
    private ModuleNode moduleNode;
    private boolean pressed;
    private boolean hover;
    private ModuleTitleBar title;
    private NavigationTreeObserver navigationTreeObserver;
    private ListenerList<IComponentUpdateListener> updateListeners;

    public ModuleView(Composite parent) {
        this.parent = parent;
        this.binding = this.createBinding();
        this.updateListeners = new ListenerList(IComponentUpdateListener.class);
        this.buildView();
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new InjectSwtViewBindingDelegate();
    }

    private void buildView() {
        this.title = new ModuleTitleBar(this.getParent(), 0);
        this.binding.addUIControl((Object)this.title, WINDOW_RIDGET);
        this.layoutTitle();
        new ModuleToolTip(this.title);
        this.body = new Composite(this.getParent(), 0x20000000);
        this.updateModuleView();
        this.createBodyContent(this.body);
    }

    private Composite getBody() {
        return this.body;
    }

    protected void createBodyContent(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.subModuleTree = new Tree(parent, 0x20000010);
        this.subModuleTree.setLinesVisible(false);
        RienaDefaultLnf lnf = LnfManager.getLnf();
        this.subModuleTree.setFont(lnf.getFont("SubModuleItem.font"));
        this.binding.addUIControl((Object)this.subModuleTree, "tree");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.subModuleTree.setLayoutData((Object)formData);
        this.addListeners();
        new SubModuleToolTip(this.subModuleTree);
        this.setTreeBackGround();
    }

    private boolean clipSubModuleTexts(GC gc, TreeItem item) {
        TreeItem[] items;
        boolean clipped = this.clipSubModuleText(gc, item);
        TreeItem[] treeItemArray = items = item.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            if (this.clipSubModuleTexts(gc, childItem)) {
                clipped = true;
            }
            ++n2;
        }
        return clipped;
    }

    private boolean clipSubModuleText(GC gc, TreeItem item) {
        boolean clipped = false;
        Rectangle treeBounds = this.getTree().getBounds();
        Rectangle itemBounds = item.getBounds();
        int maxWidth = treeBounds.width - itemBounds.x - 5;
        INavigationNode subModule = (INavigationNode)item.getData();
        String longText = "";
        longText = subModule != null ? subModule.getLabel() : item.getText();
        String text = SwtUtilities.clipText((GC)gc, (String)longText, (int)maxWidth);
        item.setText(text);
        clipped = !longText.equals(text);
        return clipped;
    }

    private void onTreePaint(GC gc) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = this.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.clipSubModuleTexts(gc, item);
            ++n2;
        }
    }

    protected void resize() {
        this.fireUpdated(null);
    }

    private void addListeners() {
        this.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem[] selection = ModuleView.this.getTree().getSelection();
                if (selection[0].getData() instanceof ISubModuleNode) {
                    ISubModuleNode activeSubModule = (ISubModuleNode)selection[0].getData();
                    activeSubModule.activate();
                }
                ModuleView.this.resize();
            }
        });
        this.getTree().addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.onTreePaint(event.gc);
            }
        });
        this.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.handleExpandCollapse(event, true);
            }
        });
        this.getTree().addListener(18, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.handleExpandCollapse(event, false);
            }
        });
        this.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.paintTreeItem(event);
            }
        });
    }

    private void paintTreeItem(Event event) {
        SubModuleTreeItemMarkerRenderer renderer = this.getTreeItemRenderer();
        renderer.setBounds(event.x, event.y, event.width, event.height);
        if (event.item instanceof TreeItem) {
            TreeItem item = (TreeItem)event.item;
            SubModuleNode node = (SubModuleNode)item.getData();
            if (node != null) {
                renderer.setMarkers(node.getMarkers());
            }
            renderer.paint(event.gc, event.item);
        }
    }

    private void handleExpandCollapse(Event event, boolean expand) {
        if (event.item instanceof TreeItem) {
            TreeItem item = (TreeItem)event.item;
            INavigationNode node = (INavigationNode)item.getData();
            node.setExpanded(expand);
        }
        this.resize();
    }

    protected void setTreeBackGround() {
        this.subModuleTree.setBackground(LnfManager.getLnf().getColor("SubModuleTree.background"));
    }

    protected Composite getParent() {
        return this.parent;
    }

    @Override
    public ModuleNode getNavigationNode() {
        return this.moduleNode;
    }

    @Override
    public void bind(ModuleNode node) {
        this.moduleNode = node;
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        this.navigationTreeObserver.addListener((IModuleNodeListener)new ModuleListener());
        this.navigationTreeObserver.addListenerTo((IModuleNode)this.moduleNode);
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)node.getNavigationNodeController();
            this.binding.injectRidgets(controller);
            this.binding.bind(controller);
            controller.afterBind();
        }
    }

    @Override
    public void unbind() {
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)this.getNavigationNode().getNavigationNodeController();
            this.binding.unbind(controller);
        }
        this.navigationTreeObserver.removeListenerFrom((IModuleNode)this.moduleNode);
        this.moduleNode = null;
    }

    public void dispose() {
        this.unbind();
        SwtUtilities.disposeWidget((Widget)this.title);
        SwtUtilities.disposeWidget((Widget)this.getBody());
        SwtUtilities.disposeWidget((Widget)this.getTree());
    }

    private Tree getTree() {
        return this.subModuleTree;
    }

    public int getOpenHeight() {
        ModuleNode navigationNode = this.getNavigationNode();
        if (navigationNode != null && navigationNode.isActivated()) {
            int depth = navigationNode.calcDepth();
            if (depth == 0) {
                return 0;
            }
            int itemHeight = this.getTree().getItemHeight();
            return depth * itemHeight + 1;
        }
        return 0;
    }

    public Rectangle getBounds() {
        Rectangle bounds = this.title.getBounds();
        if (this.getNavigationNode().isActivated()) {
            bounds.height += this.getBody().getSize().y;
        }
        return bounds;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.pressed != pressed) {
            this.pressed = pressed;
            if (!this.parent.isDisposed()) {
                this.parent.redraw();
            }
        }
    }

    public boolean isHover() {
        return this.hover;
    }

    public void setHover(boolean hover) {
        if (this.hover != hover) {
            this.hover = hover;
            if (!this.parent.isDisposed()) {
                this.parent.redraw();
            }
        }
    }

    public String getIcon() {
        if (this.getNavigationNode() == null) {
            return null;
        }
        return this.getNavigationNode().getIcon();
    }

    public boolean isActivated() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isActivated();
    }

    public boolean isVisible() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isVisible();
    }

    public boolean isCloseable() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isClosable();
    }

    public String getLabel() {
        if (this.getNavigationNode() == null) {
            return null;
        }
        return this.getNavigationNode().getLabel();
    }

    protected void fireUpdated(INavigationNode<?> node) {
        IComponentUpdateListener[] iComponentUpdateListenerArray = (IComponentUpdateListener[])this.updateListeners.getListeners();
        int n = iComponentUpdateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentUpdateListener listener = iComponentUpdateListenerArray[n2];
            listener.update(node);
            ++n2;
        }
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        this.updateListeners.add((Object)listener);
    }

    private ModuleGroupRenderer getMouduleGroupRenderer() {
        ModuleGroupRenderer renderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (renderer == null) {
            renderer = new ModuleGroupRenderer();
        }
        return renderer;
    }

    private SubModuleTreeItemMarkerRenderer getTreeItemRenderer() {
        SubModuleTreeItemMarkerRenderer renderer = (SubModuleTreeItemMarkerRenderer)LnfManager.getLnf().getRenderer("SubModuleTreeItemMarker.renderer");
        if (renderer == null) {
            renderer = new SubModuleTreeItemMarkerRenderer();
        }
        return renderer;
    }

    public void updateModuleView() {
        boolean active = false;
        if (this.getNavigationNode() != null) {
            active = this.getNavigationNode().isActivated();
        }
        if (!SwtUtilities.isDisposed((Widget)this.title)) {
            this.layoutTitle();
        }
        if (!SwtUtilities.isDisposed((Widget)this.getBody())) {
            this.getBody().setVisible(active);
            int height = this.getOpenHeight();
            if (this.getBody().getSize().y != height) {
                FormData formData = new FormData();
                formData.top = new FormAttachment((Control)this.title);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.height = height;
                this.getBody().setLayoutData((Object)formData);
            }
        }
        this.getParent().layout();
        this.title.setWindowActive(active);
    }

    private void layoutTitle() {
        Control[] children = this.getParent().getChildren();
        FormData formData = new FormData();
        int index = -1;
        int i = 0;
        while (i < children.length) {
            if (children[i] == this.title) {
                index = i;
                break;
            }
            ++i;
        }
        formData.top = index == 0 ? new FormAttachment(0, 0) : (index < 0 ? new FormAttachment(children[children.length - 1], this.getMouduleGroupRenderer().getModuleModuleGap()) : new FormAttachment(children[index - 1], this.getMouduleGroupRenderer().getModuleModuleGap()));
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = this.title.getSize().y;
        this.title.setLayoutData((Object)formData);
    }

    private class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void filterAdded(IModuleNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            ModuleView.this.updateModuleView();
        }

        public void filterRemoved(IModuleNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            ModuleView.this.updateModuleView();
        }

        public void activated(IModuleNode source) {
            super.activated((INavigationNode)source);
            ModuleView.this.updateModuleView();
        }

        public void disposed(IModuleNode source) {
            super.disposed((INavigationNode)source);
            ModuleView.this.dispose();
        }

        public void markersChanged(IModuleNode source) {
            super.markersChanged((INavigationNode)source);
            ModuleView.this.title.setMarkers(source.getMarkers());
            ModuleView.this.title.redraw();
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void filterAdded(ISubModuleNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            ModuleView.this.updateModuleView();
        }

        public void filterRemoved(ISubModuleNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            ModuleView.this.updateModuleView();
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            ModuleView.this.resize();
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            ModuleView.this.resize();
        }

        public void activated(ISubModuleNode source) {
            ModuleView.this.resize();
        }

        public void markersChanged(ISubModuleNode source) {
            ModuleView.this.getTree().redraw();
        }
    }
}

