/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleGroupController;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProviderAccessor;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.IViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class NavigationViewPart
extends ViewPart {
    public static final String ID = "org.eclipse.riena.navigation.ui.swt.views.navigationViewPart";
    private IViewFactory viewFactory;
    private Composite parent;
    private Composite bodyComposite;
    private NavigationTreeObserver navigationTreeObserver;
    private Map<INavigationNode<?>, ModuleGroupView> moduleGroupNodesToViews;
    private Map<INavigationNode<?>, ModuleView> moduleNodesToViews;
    private List<ModuleGroupView> moduleGroupViews = new ArrayList<ModuleGroupView>();

    public NavigationViewPart() {
        this.markAsNavigation();
        this.moduleGroupNodesToViews = new HashMap();
        this.moduleNodesToViews = new HashMap();
    }

    protected IViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new NavigationViewFactory();
        }
        return this.viewFactory;
    }

    private void markAsNavigation() {
        this.setPartProperty("navigation", String.valueOf(Boolean.TRUE));
    }

    private ISubApplicationNode getSubApplicationNode() {
        String perspectiveID = this.getViewSite().getPage().getPerspective().getId();
        return SwtViewProviderAccessor.getViewProvider().getNavigationNode(perspectiveID, ISubApplicationNode.class);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.initLayoutParts();
        this.buildNavigationViewHierarchy();
        this.initModelObserver();
    }

    private void initLayoutParts() {
        this.bodyComposite = new Composite(this.parent, 0x20000000);
        this.bodyComposite.setBackground(LnfManager.getLnf().getColor("Navigation.background"));
        this.bodyComposite.setLayout((Layout)new FormLayout());
    }

    private void buildNavigationViewHierarchy() {
        ISubApplicationNode subApplicationNode = this.getSubApplicationNode();
        for (IModuleGroupNode moduleGroupNode : subApplicationNode.getChildren()) {
            this.createModuleGroupView(moduleGroupNode);
        }
        this.updateNavigationSize();
    }

    private void initModelObserver() {
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.navigationTreeObserver.addListener((ISubApplicationNodeListener)new SubApplicationListener());
        this.navigationTreeObserver.addListener((IModuleGroupNodeListener)new ModuleGroupListener());
        this.navigationTreeObserver.addListenerTo(this.getSubApplicationNode());
    }

    private void createModuleGroupView(IModuleGroupNode moduleGroupNode) {
        ModuleGroupView moduleGroupView = this.getViewFactory().createModuleGroupView(this.bodyComposite);
        this.moduleGroupNodesToViews.put((INavigationNode<?>)moduleGroupNode, moduleGroupView);
        moduleGroupView.addUpdateListener(new ModuleGroupViewObserver());
        this.registerModuleGroupView(moduleGroupView);
        new ModuleGroupController(moduleGroupNode);
        moduleGroupView.bind((ModuleGroupNode)moduleGroupNode);
        moduleGroupView.setLayout((Layout)new FormLayout());
        Composite moduleGroupBody = new Composite((Composite)moduleGroupView, 0);
        FormData layoutData = new FormData();
        int padding = this.getModuleGroupPadding();
        layoutData.top = new FormAttachment(0, padding);
        layoutData.left = new FormAttachment(0, padding);
        layoutData.bottom = new FormAttachment(100, -padding);
        layoutData.right = new FormAttachment(100, -padding);
        moduleGroupBody.setLayoutData((Object)layoutData);
        for (IModuleNode moduleNode : moduleGroupNode.getChildren()) {
            this.createModuleView(moduleNode, moduleGroupView);
        }
    }

    private void registerModuleGroupView(ModuleGroupView moduleGroupView) {
        this.moduleGroupViews.add(moduleGroupView);
    }

    public void unregisterModuleGroupView(IModuleGroupNode moduleGroupNode) {
        for (ModuleGroupView moduleGroupView : this.moduleGroupViews) {
            if (moduleGroupView.getNavigationNode() != moduleGroupNode) continue;
            this.unregisterModuleGroupView(moduleGroupView, moduleGroupNode);
            break;
        }
    }

    private void unregisterModuleGroupView(ModuleGroupView moduleGroupView, IModuleGroupNode node) {
        this.moduleGroupNodesToViews.remove(node);
        this.moduleGroupViews.remove(moduleGroupView);
    }

    private void createModuleView(IModuleNode moduleNode, ModuleGroupView moduleGroupView) {
        Composite moduleGroupBody = (Composite)moduleGroupView.getChildren()[0];
        FormLayout layout = new FormLayout();
        moduleGroupBody.setLayout((Layout)layout);
        ModuleView moduleView = this.viewFactory.createModuleView(moduleGroupBody);
        this.moduleNodesToViews.put((INavigationNode<?>)moduleNode, moduleView);
        new SWTModuleController(moduleNode);
        moduleView.bind((ModuleNode)moduleNode);
        moduleGroupView.registerModuleView(moduleView);
    }

    public void updateNavigationSize() {
        int yPos = 0;
        for (ModuleGroupView moduleGroupView : this.moduleGroupViews) {
            yPos = moduleGroupView.calculateBounds(yPos);
        }
        this.bodyComposite.layout();
        this.bodyComposite.redraw();
    }

    private ModuleGroupRenderer getModuleGroupRenderer() {
        ModuleGroupRenderer renderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (renderer == null) {
            renderer = new ModuleGroupRenderer();
        }
        return renderer;
    }

    private EmbeddedBorderRenderer getLnfBorderRenderer() {
        EmbeddedBorderRenderer renderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.borderRenderer");
        if (renderer == null) {
            renderer = new EmbeddedBorderRenderer();
        }
        return renderer;
    }

    private int getModuleGroupPadding() {
        return this.getModuleGroupRenderer().getModuleGroupPadding() + this.getLnfBorderRenderer().getBorderWidth();
    }

    public void setFocus() {
    }

    private class ModuleGroupListener
    extends ModuleGroupNodeListener {
        private ModuleGroupListener() {
        }

        public void filterAdded(IModuleGroupNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void filterRemoved(IModuleGroupNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void childAdded(IModuleGroupNode source, IModuleNode child) {
            ModuleGroupView moduleGroupView = (ModuleGroupView)NavigationViewPart.this.moduleGroupNodesToViews.get(source);
            NavigationViewPart.this.createModuleView(child, moduleGroupView);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void childRemoved(IModuleGroupNode source, IModuleNode child) {
            NavigationViewPart.this.moduleNodesToViews.remove(child);
        }

        public void disposed(IModuleGroupNode source) {
            super.disposed((INavigationNode)source);
            NavigationViewPart.this.unregisterModuleGroupView(source);
            NavigationViewPart.this.updateNavigationSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ModuleGroupViewObserver
    implements IComponentUpdateListener {
        private ModuleGroupViewObserver() {
        }

        @Override
        public void update(INavigationNode<?> node) {
            NavigationViewPart.this.updateNavigationSize();
        }
    }

    private class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void childAdded(ISubApplicationNode source, IModuleGroupNode child) {
            NavigationViewPart.this.createModuleGroupView(child);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void filterAdded(ISubApplicationNode source, IUIFilter filter) {
            super.filterAdded((INavigationNode)source, filter);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void filterRemoved(ISubApplicationNode source, IUIFilter filter) {
            super.filterRemoved((INavigationNode)source, filter);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void childRemoved(ISubApplicationNode source, IModuleGroupNode child) {
            NavigationViewPart.this.unregisterModuleGroupView(child);
            NavigationViewPart.this.updateNavigationSize();
        }
    }
}

