/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.application;

import java.util.TreeSet;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.navigation.ui.Activator;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationAssembler;
import org.eclipse.riena.navigation.INavigationAssemblyExtension;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.INodeExtension;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.NavigationNodeProvider;
import org.eclipse.riena.navigation.model.NavigationNodeProviderAccessor;
import org.eclipse.riena.navigation.ui.application.VisualizerFactory;
import org.eclipse.riena.navigation.ui.login.ILoginDialogViewDefinition;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerLocator;
import org.eclipse.riena.ui.core.uiprocess.ProgressProviderBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplication
implements IApplication {
    private static final Logger LOGGER = Activator.getDefault().getLogger(AbstractApplication.class);
    protected ILoginDialogViewDefinition loginDialogViewDefinition;

    public Object start(IApplicationContext context) throws Exception {
        Object result = this.initializePerformLogin(context);
        if (!EXIT_OK.equals(result)) {
            return result;
        }
        IApplicationNode node = this.createModel();
        if (node == null) {
            throw new RuntimeException("Application did not return an ApplicationModel in method 'createModel' but returned NULL. Cannot continue");
        }
        this.createStartupsFromExtensions(node);
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)node);
        this.initializeNode(node);
        this.setProgressProviderBridge();
        return this.createView(context, node);
    }

    private void setProgressProviderBridge() {
        ProgressProviderBridge bridge = ProgressProviderBridge.instance();
        Job.getJobManager().setProgressProvider((ProgressProvider)bridge);
        bridge.setVisualizerFactory((IProgressVisualizerLocator)new VisualizerFactory());
    }

    protected IApplicationNode createModel() {
        ApplicationNode applicationModel = new ApplicationNode(new NavigationNodeId("application"));
        return applicationModel;
    }

    protected void createStartupsFromExtensions(IApplicationNode applicationNode) {
        TreeSet<StartupSortable> startups = new TreeSet<StartupSortable>();
        INavigationNodeProvider nnp = NavigationNodeProviderAccessor.current().getNavigationNodeProvider();
        Integer sequence = null;
        String id = null;
        for (INavigationAssembler assembler : ((NavigationNodeProvider)nnp).getNavigationAssemblers()) {
            sequence = this.getAutostartSequence(assembler.getAssembly());
            if (sequence == null) continue;
            id = this.getTypeId((INodeExtension)assembler.getAssembly().getSubApplicationNode());
            if (id != null) {
                startups.add(new StartupSortable(StartupLevel.SUBAPPLICATION, sequence, id));
                continue;
            }
            id = this.getTypeId((INodeExtension)assembler.getAssembly().getModuleGroupNode());
            if (id != null) {
                startups.add(new StartupSortable(StartupLevel.MODULEGROUP, sequence, id));
                continue;
            }
            id = this.getTypeId((INodeExtension)assembler.getAssembly().getModuleNode());
            if (id != null) {
                startups.add(new StartupSortable(StartupLevel.MODULE, sequence, id));
                continue;
            }
            id = this.getTypeId((INodeExtension)assembler.getAssembly().getSubModuleNode());
            if (id != null) {
                startups.add(new StartupSortable(StartupLevel.SUBMODULE, sequence, id));
                continue;
            }
            id = assembler.getAssembly().getId();
            if (id == null) continue;
            startups.add(new StartupSortable(StartupLevel.CUSTOM, sequence, id));
        }
        for (StartupSortable startup : startups) {
            String message = "creating startup module %s [level=%s sequence=%d]";
            LOGGER.log(3, String.format(message, new Object[]{startup.id, startup.level, startup.sequence}));
            applicationNode.create(new NavigationNodeId(startup.id));
        }
    }

    protected void initializeNode(IApplicationNode model) {
        this.initializeModelDefaults(model);
    }

    protected void initializeModelDefaults(IApplicationNode model) {
        this.initializeNodeDefaults(model);
    }

    protected void initializeNodeDefaults(IApplicationNode node) {
        for (ISubApplicationNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaults(ISubApplicationNode node) {
        for (IModuleGroupNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaults(IModuleGroupNode node) {
        for (IModuleNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaults(IModuleNode node) {
        this.initializeNodeDefaultIcon((INavigationNode<?>)node);
        for (ISubModuleNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaults(ISubModuleNode node) {
        this.initializeNodeDefaultIcon((INavigationNode<?>)node);
        for (ISubModuleNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaultIcon(INavigationNode<?> node) {
        if (node.getIcon() == null) {
            node.setIcon("0044");
        }
    }

    protected abstract Object createView(IApplicationContext var1, IApplicationNode var2) throws Exception;

    protected Object initializePerformLogin(IApplicationContext context) throws Exception {
        this.initializeLoginViewDefinition();
        if (this.isDialogLogin(context)) {
            return this.performLogin(context);
        }
        return EXIT_OK;
    }

    protected boolean isDialogLogin(IApplicationContext context) {
        return this.loginDialogViewDefinition != null;
    }

    protected boolean isSplashLogin(IApplicationContext context) {
        return false;
    }

    protected Object doPerformLogin(IApplicationContext context) {
        return EXIT_OK;
    }

    protected Object doPerformSplashLogin(IApplicationContext context) {
        return EXIT_OK;
    }

    protected Object performLogin(IApplicationContext context) throws Exception {
        if (this.isSplashLogin(context)) {
            return this.doPerformSplashLogin(context);
        }
        return this.doPerformLogin(context);
    }

    public void update(ILoginDialogViewDefinition[] data) {
        if (data.length > 0) {
            this.loginDialogViewDefinition = data[0];
        }
    }

    protected void initializeLoginViewDefinition() {
        Inject.extension((String)"org.eclipse.riena.navigation.ui.loginDialogViewDefinition").useType(ILoginDialogViewDefinition.class).into((Object)this).andStart(Activator.getDefault().getContext());
    }

    private Integer getAutostartSequence(INavigationAssemblyExtension assembly) {
        try {
            return assembly.getAutostartSequence();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getTypeId(INodeExtension extension) {
        if (extension == null) {
            return null;
        }
        return extension.getTypeId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StartupLevel {
        SUBAPPLICATION,
        MODULEGROUP,
        MODULE,
        SUBMODULE,
        CUSTOM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StartupSortable
    implements Comparable<StartupSortable> {
        public final StartupLevel level;
        public final int sequence;
        public final String id;

        public StartupSortable(StartupLevel level, Integer sequence, String id) {
            this.level = level;
            this.sequence = sequence;
            this.id = id;
        }

        @Override
        public int compareTo(StartupSortable o) {
            if (this.level.compareTo(o.level) != 0) {
                return this.level.compareTo(o.level);
            }
            return this.sequence - o.sequence;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + this.sequence;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StartupSortable other = (StartupSortable)obj;
            if (this.level == null ? other.level != null : !this.level.equals((Object)other.level)) {
                return false;
            }
            return this.sequence == other.sequence;
        }
    }
}

