/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.delta;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.objecttransaction.IObjectId;
import org.eclipse.riena.objecttransaction.ObjectTransactionFailure;
import org.eclipse.riena.objecttransaction.delta.AbstractBaseChange;
import org.eclipse.riena.objecttransaction.delta.MultipleChange;
import org.eclipse.riena.objecttransaction.delta.SingleChange;
import org.eclipse.riena.objecttransaction.state.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionDelta
implements Cloneable {
    private IObjectId objectId;
    private State state;
    private String version;
    private Map<String, AbstractBaseChange> referenceChanges;

    public TransactionDelta(IObjectId objectId, State state, String version) {
        this.setObjectId(objectId);
        this.setState(state);
        this.setVersion(version);
        this.referenceChanges = new HashMap<String, AbstractBaseChange>();
    }

    public IObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(IObjectId objectId) {
        this.objectId = objectId;
    }

    public void setSingleRefObject(String refName, Object childObject) {
        this.referenceChanges.put(refName, new SingleChange(refName, childObject));
    }

    public boolean hasSingleRefObject(String refName) {
        SingleChange sEntry = (SingleChange)this.referenceChanges.get(refName);
        return sEntry != null;
    }

    public Object getSingleRefObject(String refName) {
        SingleChange sEntry = (SingleChange)this.referenceChanges.get(refName);
        if (sEntry == null) {
            return null;
        }
        return sEntry.getChildObject();
    }

    public void addMultiRefObject(String refName, Object childObject) {
        AbstractBaseChange baseEntry = this.referenceChanges.get(refName);
        if (!(baseEntry instanceof MultipleChange) && baseEntry != null) {
            throw new ObjectTransactionFailure("impossible to add a reference to refName" + refName + "as it was previously used with a set object, which creates a 1:1 reference.");
        }
        MultipleChange entry = (MultipleChange)baseEntry;
        if (entry == null) {
            entry = new MultipleChange(refName);
            this.referenceChanges.put(refName, entry);
        }
        entry.addEntry(childObject);
    }

    public void removeMultiRefObject(String refName, Object childObject) {
        AbstractBaseChange baseEntry = this.referenceChanges.get(refName);
        if (!(baseEntry instanceof MultipleChange) && baseEntry != null) {
            throw new ObjectTransactionFailure("impossible to add a reference to refName" + refName + "as it was previously used with a set object, which creates a 1:1 reference.");
        }
        MultipleChange entry = (MultipleChange)baseEntry;
        if (entry == null) {
            entry = new MultipleChange(refName);
            this.referenceChanges.put(refName, entry);
        }
        entry.removeEntry(childObject);
    }

    protected Map<String, AbstractBaseChange> getAllChanges() {
        return this.referenceChanges;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isClean() {
        return this.state.equals(State.CLEAN);
    }

    public boolean isModified() {
        return this.state.equals(State.MODIFIED);
    }

    public boolean isCreated() {
        return this.state.equals(State.CREATED);
    }

    public boolean isDeleted() {
        return this.state.equals(State.DELETED);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, AbstractBaseChange> getChanges() {
        return this.referenceChanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("##### objectId:" + this.objectId + " #####\n");
        sb.append("state:" + State.toString(this.state) + "\n");
        sb.append("reference Changes ---START---\n");
        for (Map.Entry<String, AbstractBaseChange> entry : this.referenceChanges.entrySet()) {
            sb.append(String.valueOf(entry.toString()) + "\n");
        }
        sb.append("reference Changes ---END---\n");
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        TransactionDelta delta = (TransactionDelta)super.clone();
        delta.referenceChanges = (Map)((HashMap)this.referenceChanges).clone();
        return delta;
    }
}

