/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.sample.app.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.attachment.Attachment;
import org.eclipse.riena.internal.sample.app.server.Activator;
import org.eclipse.riena.internal.sample.app.server.SampleInputStream;
import org.eclipse.riena.sample.app.common.attachment.IAttachmentService;

public final class AttachmentService
implements IAttachmentService {
    private static final int ATTACHMENT_START = 60;
    private static final Logger LOGGER = Activator.getDefault().getLogger(AttachmentService.class);
    private static final String TESTDATA1 = "das sind testdaten, die wir mal einfach so verschicken um etwas zu testen.";

    public String sendSingleAttachment(Attachment singleAttachment) {
        return this.readAttachmentStart(singleAttachment);
    }

    private String readAttachmentStart(Attachment attachment) {
        byte[] byteArray = new byte[60];
        try {
            InputStream input = attachment.readAsStream();
            int nbrBytes = input.read(byteArray, 0, byteArray.length);
            if (nbrBytes < 1) {
                throw new IOException("Empty Attachment.");
            }
        }
        catch (IOException iOException) {
            return "[can't read " + attachment + "]";
        }
        return new String(byteArray);
    }

    public String sendTwoAttachments(Attachment firstAttachment, Attachment secondAttachment) {
        return String.valueOf(this.readAttachmentStart(firstAttachment)) + "+" + this.readAttachmentStart(secondAttachment);
    }

    public String sendAttachmentsAndData(String firstString, Attachment firstAttachment, String secondString, Attachment secondAttachment, String thirdString, int number) {
        return String.valueOf(firstString) + "+" + this.readAttachmentStart(firstAttachment) + "+" + secondString + "+" + this.readAttachmentStart(secondAttachment) + "+" + thirdString + "+" + number;
    }

    public Attachment returnAttachment() throws IOException {
        return new Attachment(this.setupTestFile(TESTDATA1));
    }

    public Attachment returnAttachmentForRequest(String attachmentName) throws IOException {
        if (attachmentName.equals("validfilename")) {
            return new Attachment(this.setupTestFile(TESTDATA1));
        }
        if (attachmentName.equals("invalidfilename")) {
            throw new FileNotFoundException(String.valueOf(attachmentName) + " not found");
        }
        throw new RuntimeException("invalid request");
    }

    public Attachment sendAndReturnAttachment(Attachment attachment) {
        LOGGER.log(4, this.readAttachmentStart(attachment));
        return attachment;
    }

    public InputStream getFile() {
        try {
            return new BufferedInputStream(new FileInputStream(this.setupTestFile(TESTDATA1)));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Attachment getBytesFromSampleWithError() throws IOException {
        return new Attachment((InputStream)new SampleInputStream());
    }

    public Attachment getBytesFromUrlWithErrorAtStart() {
        try {
            URL url = new URL("http://localhost:20080/");
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            if (httpConn.getResponseCode() > 399) {
                String errorMsg = "no error msg";
                if (httpConn.getErrorStream().available() > 0) {
                    byte[] buffer = new byte[httpConn.getErrorStream().available()];
                    httpConn.getErrorStream().read(buffer, 0, buffer.length);
                }
                throw new RuntimeException("rc=" + httpConn.getResponseCode() + " msg=" + errorMsg);
            }
            return new Attachment(url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Attachment getBytesFromUrlWithError() {
        try {
            return new Attachment(new URL("http://localhost:8080/junittest/errorinthemiddle"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public Attachment getBytesFromUrlWithoutError() {
        try {
            URL url = new URL("http://localhost:8080/junittest/validoutput");
            return new Attachment(url);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public Attachment getAttachmentForSize(int sizeInBytes) throws IOException {
        int countInBytes = sizeInBytes;
        return new Attachment(new InputStream(countInBytes){
            private int count;
            private SecureRandom random;
            {
                this.count = n;
                this.random = new SecureRandom();
            }

            public int read() throws IOException {
                --this.count;
                if (this.count >= 0) {
                    return this.random.nextInt();
                }
                return -1;
            }
        });
    }

    public Attachment getBytesFromInvalidUrl() throws IOException {
        try {
            return new Attachment(new URL("http://localhost:24444/unittest/errorinthemiddle"));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void sendFile(Attachment attachment) {
    }

    public Object getAttachmentAsObject() throws IOException {
        try {
            return new Attachment(this.setupTestFile(TESTDATA1));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public Attachment getEmptyAttachment() throws IOException {
        return new Attachment(new InputStream(){

            public int read() throws IOException {
                return -1;
            }
        });
    }

    public int sendAttachmentAndReturnSize(Attachment attachment) throws IOException {
        InputStream readAsStream = attachment.readAsStream();
        int i = 0;
        while (readAsStream.read() != -1) {
            ++i;
        }
        readAsStream.close();
        return i;
    }

    public Attachment returnAttachmentForSize(int size) throws IOException {
        return this.generateLargeAttachment(size);
    }

    private File setupTestFile(String string) {
        try {
            File file = File.createTempFile("attachTest", null);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.write(string);
            printWriter.close();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private Attachment generateLargeAttachment(int countInBytes) throws IOException {
        return new Attachment(new InputStream(countInBytes){
            private int count;
            private SecureRandom random;
            {
                this.count = n;
                this.random = new SecureRandom();
            }

            public int read() throws IOException {
                --this.count;
                if (this.count >= 0) {
                    return this.random.nextInt();
                }
                return -1;
            }
        });
    }
}

