/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.navigation.ui.swt.views.DialogView;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SnippetDialogView001 {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            final Shell shell = new Shell();
            GridLayoutFactory.fillDefaults().applyTo((Composite)shell);
            Button button = new Button((Composite)shell, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
            IActionRidget actionRidget = (IActionRidget)SwtRidgetFactory.createRidget((Object)button);
            actionRidget.setText("Open dialog");
            actionRidget.addListener(new IActionListener(){

                public void callback() {
                    new HelloDialogView(shell).build();
                }
            });
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private static class HelloDialogController
    extends AbstractWindowController {
        public static final String RIDGET_ID_INPUT = "input";
        public static final String RIDGET_ID_OK = "okButton";
        public static final String RIDGET_ID_CANCEL = "cancelButton";

        private HelloDialogController() {
        }

        public void configureRidgets() {
            super.configureRidgets();
            this.getWindowRidget().setTitle("Hello Dialog");
            ITextRidget input = (ITextRidget)this.getRidget(RIDGET_ID_INPUT);
            input.setText("Input please");
            IActionRidget okAction = (IActionRidget)this.getRidget(RIDGET_ID_OK);
            okAction.addListener(new IActionListener(){

                public void callback() {
                    HelloDialogController.this.getWindowRidget().dispose();
                }
            });
            IActionRidget cancelAction = (IActionRidget)this.getRidget(RIDGET_ID_CANCEL);
            cancelAction.addListener(new IActionListener(){

                public void callback() {
                    HelloDialogController.this.getWindowRidget().dispose();
                }
            });
        }
    }

    private static class HelloDialogView
    extends DialogView {
        public HelloDialogView(Shell shell) {
            super((Composite)shell);
        }

        protected AbstractWindowController createController() {
            return new HelloDialogController();
        }

        protected Control buildView(Composite parent) {
            super.buildView(parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            UIControlsFactory.createLabel((Composite)composite, (String)"Input");
            Text input = UIControlsFactory.createText((Composite)composite);
            this.addUIControl(input, "input");
            Button okButton = UIControlsFactory.createButton((Composite)composite);
            okButton.setText("Ok");
            this.addUIControl(okButton, "okButton");
            Button cancelButton = UIControlsFactory.createButton((Composite)composite);
            cancelButton.setText("Cancel");
            this.addUIControl(cancelButton, "cancelButton");
            return composite;
        }
    }
}

