/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common;

import java.util.Map;
import org.eclipse.riena.communication.core.hooks.CallContext;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.common.Activator;
import org.eclipse.riena.security.common.session.ISessionHolder;
import org.eclipse.riena.security.common.session.ISessionHolderService;
import org.eclipse.riena.security.common.session.Session;

public class SecurityCallHook
implements ICallHook {
    private static final String SSOID = "x-compeople-ssoid";
    private ISessionHolderService shService;

    public SecurityCallHook() {
        Inject.service((String)ISessionHolderService.class.getName()).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(ISessionHolderService shService) {
        this.shService = shService;
    }

    public void unbind(ISessionHolderService shService) {
        if (this.shService == shService) {
            this.shService = null;
        }
    }

    public void beforeCall(CallContext callback) {
        ISessionHolder sessionHolder = this.shService.fetchSessionHolder();
        Session session = sessionHolder.getSession();
        if (session != null) {
            callback.setCookie(SSOID, session.getSessionId());
        }
    }

    public void afterCall(CallContext callback) {
        ISessionHolder sessionHolder = this.shService.fetchSessionHolder();
        Map map = callback.getSetCookies();
        if (map == null) {
            return;
        }
        String temp = (String)map.get(SSOID);
        if (temp != null) {
            sessionHolder.setSession(new Session(temp));
        }
    }
}

