/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common.authorization;

import java.security.Permissions;
import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.riena.core.cache.GenericObjectCache;
import org.eclipse.riena.core.util.ContainerModel;
import org.eclipse.riena.security.common.authorization.IPermissionCache;

public class PermissionCache
implements IPermissionCache {
    private final GenericObjectCache<String, Permissions> permCache = new GenericObjectCache();

    public PermissionCache() {
        this.permCache.setName("PermissionCache");
        if (ContainerModel.isClient()) {
            this.permCache.setMinimumSize(1);
            this.permCache.setTimeout(999999000);
        } else {
            this.permCache.setMinimumSize(100);
            this.permCache.setTimeout(360000);
        }
    }

    public Permissions getPermissions(Principal principal) {
        return (Permissions)this.permCache.get((Object)principal.getName());
    }

    public void putPermissions(Principal principal, Permissions permissions) {
        this.permCache.put((Object)principal.getName(), (Object)permissions);
    }

    public void purgePermissions(Subject subject) {
    }

    public void purgePermissions(Principal principal) {
    }
}

