/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common;

import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.riena.communication.core.hooks.CallContext;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.common.Activator;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.ISubjectHolderService;
import sun.misc.BASE64Encoder;

public class BasicAuthenticationCallHook
implements ICallHook {
    private ISubjectHolderService subjectHolderService = null;

    public BasicAuthenticationCallHook() {
        Inject.service((String)ISubjectHolderService.class.getName()).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(ISubjectHolderService subjectHolderService) {
        this.subjectHolderService = subjectHolderService;
    }

    public void unbind(ISubjectHolderService subjectHolderService) {
        this.subjectHolderService = null;
    }

    public void afterCall(CallContext context) {
    }

    public void beforeCall(CallContext context) {
        Subject subject;
        ISubjectHolder subjectHolder = this.subjectHolderService.fetchSubjectHolder();
        if (subjectHolder != null && (subject = subjectHolder.getSubject()) != null) {
            Object psw = subject.getPrivateCredentials().iterator().next();
            String password = psw != null && psw instanceof String ? (String)psw : "";
            for (Principal principal : subject.getPrincipals()) {
                String useridPlusPassword = String.valueOf(principal.getName()) + ":" + password;
                String authorizationInBase64 = new BASE64Encoder().encode(useridPlusPassword.getBytes());
                context.getMessageContext().addRequestHeader("Authorization", "Basic " + authorizationInBase64);
            }
        }
    }
}

