/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common;

import javax.security.auth.Subject;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.common.Activator;
import org.eclipse.riena.security.common.ISubjectHolderService;

public final class SubjectAccessor {
    private ISubjectHolderService subjectHolderService;
    private static SubjectAccessor myself;

    private SubjectAccessor() {
        Inject.service((String)ISubjectHolderService.class.getName()).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public static Subject getSubject() {
        return SubjectAccessor.getInstance().getCurrentSubject();
    }

    public static void setSubject(Subject subject) {
        SubjectAccessor.getInstance().setCurrentSubject(subject);
    }

    private static SubjectAccessor getInstance() {
        if (myself == null) {
            myself = new SubjectAccessor();
        }
        return myself;
    }

    public void bind(ISubjectHolderService subjectHolderService) {
        this.subjectHolderService = subjectHolderService;
    }

    public void unbind(ISubjectHolderService subjectHolderService) {
        this.subjectHolderService = null;
    }

    public Subject getCurrentSubject() {
        return this.subjectHolderService.fetchSubjectHolder().getSubject();
    }

    public void setCurrentSubject(Subject subject) {
        this.subjectHolderService.fetchSubjectHolder().setSubject(subject);
    }
}

