/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.logging.ConsoleLogger;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class ConsoleLoggerTest
extends RienaTestCase {
    private Logger logger;

    protected void setUp() throws Exception {
        super.setUp();
        this.logger = new ConsoleLogger(ConsoleLoggerTest.class.getName());
    }

    public void testLevels() {
        this.logger.log(4, "This is debug!");
        this.logger.log(1, "This is error!");
        this.logger.log(3, "This is info!");
        this.logger.log(2, "This is warning!");
        this.logger.log(-1, "This is unknown!");
    }

    public void testWithExceptions() {
        IOException ioe = new IOException("Oops!");
        this.logger.log(1, "This is an error!", (Throwable)ioe);
    }

    public void testWithContext() {
        this.logger.log((Object)"CONTEXT", 3, "Message with context.");
    }

    public void testWithServiceReference() throws InvalidSyntaxException {
        String stringService = "Very simple service";
        ServiceRegistration sr = this.getContext().registerService(String.class.getName(), (Object)stringService, null);
        Assert.assertTrue((sr.getReference() != null ? 1 : 0) != 0);
        this.logger.log(sr.getReference(), 3, "Message with context.");
        sr.unregister();
    }

    public void testWithBadInput() throws InvalidSyntaxException {
        this.logger.log(null, 0, null, null);
        this.logger.log(null, 0, null, null);
    }
}

