/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.marker;

import org.eclipse.riena.core.marker.AbstractMarker;
import org.eclipse.riena.core.marker.IMarkerAttributeChangeListener;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class AbstractMarkerTest
extends RienaTestCase {
    public void testAbstractMarker() {
        DummyMarker marker = new DummyMarker();
        AbstractMarkerTest.assertTrue((boolean)marker.isUnique());
    }

    public void testToString() {
        DummyMarker marker = new DummyMarker();
        AbstractMarkerTest.assertEquals((String)"DummyMarker[attributes={unique=true}]", (String)marker.toString());
        marker.setAttribute("att", "val");
        AbstractMarkerTest.assertEquals((String)"DummyMarker[attributes={unique=true, att=val}]", (String)marker.toString());
        marker = new DummyMarker(false);
        AbstractMarkerTest.assertEquals((String)"DummyMarker[attributes={}]", (String)marker.toString());
    }

    public void testSetAttribute() {
        DummyMarker marker = new DummyMarker();
        AbstractMarkerTest.assertNull((Object)marker.getAttribute("lastname"));
        marker.reset();
        marker.setAttribute("lastname", "Gate");
        AbstractMarkerTest.assertEquals((Object)"Gate", (Object)marker.getAttribute("lastname"));
        AbstractMarkerTest.assertTrue((boolean)marker.isChangeFired());
        marker.reset();
        marker.setAttribute("lastname", "Ballmer");
        AbstractMarkerTest.assertEquals((Object)"Ballmer", (Object)marker.getAttribute("lastname"));
        AbstractMarkerTest.assertTrue((boolean)marker.isChangeFired());
        marker.reset();
        marker.setAttribute("lastname", null);
        AbstractMarkerTest.assertNull((Object)marker.getAttribute("lastname"));
        AbstractMarkerTest.assertTrue((boolean)marker.isChangeFired());
        marker.reset();
        marker.setAttribute("lastname", 12);
        AbstractMarkerTest.assertEquals((Object)12, (Object)marker.getAttribute("lastname"));
        AbstractMarkerTest.assertTrue((boolean)marker.isChangeFired());
        marker.reset();
        try {
            marker.setAttribute(null, 12);
            AbstractMarkerTest.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            this.ok("Exception expected");
        }
        AbstractMarkerTest.assertFalse((boolean)marker.isChangeFired());
    }

    public void testGetAttribute() {
        DummyMarker marker = new DummyMarker();
        AbstractMarkerTest.assertEquals((Object)"unkown", (Object)marker.getAttribute("lastname", "unkown"));
        marker.setAttribute("lastname", "Gate");
        AbstractMarkerTest.assertEquals((Object)"Gate", (Object)marker.getAttribute("lastname", "unkown"));
        marker.setAttribute("lastname", null);
        AbstractMarkerTest.assertEquals((Object)"unkown", (Object)marker.getAttribute("lastname", "unkown"));
    }

    private static class DummyMarker
    extends AbstractMarker
    implements IMarkerAttributeChangeListener {
        private boolean changeFired;

        public DummyMarker() {
            this.init();
        }

        public DummyMarker(boolean unique) {
            super(unique);
            this.init();
        }

        private void init() {
            this.addAttributeChangeListener(this);
            this.reset();
        }

        public void attributesChanged() {
            this.changeFired = true;
        }

        public void reset() {
            this.changeFired = false;
        }

        public boolean isChangeFired() {
            return this.changeFired;
        }
    }
}

