/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.filter;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.navigation.ui.filter.MenuItemRidgetMatcher;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MenuItemRidgetMatcherTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        MenuItemRidgetMatcherTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testMatches() {
        MenuItemRidgetMatcher matcher = new MenuItemRidgetMatcher("4711");
        MenuItemRidget ridget = new MenuItemRidget();
        MenuItemRidgetMatcherTest.assertFalse((boolean)matcher.matches(new Object[]{ridget}));
        Menu menu = new Menu((Control)this.shell);
        MenuItem item = new MenuItem(menu, 0);
        ridget.setUIControl((Object)item);
        MenuItemRidgetMatcherTest.assertFalse((boolean)matcher.matches(new Object[]{ridget}));
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)item, "4711");
        MenuItemRidgetMatcherTest.assertFalse((boolean)matcher.matches(new Object[]{ridget}));
        locator.setBindingProperty((Object)item, "menuAction.4711");
        MenuItemRidgetMatcherTest.assertTrue((boolean)matcher.matches(new Object[]{ridget}));
        matcher = new MenuItemRidgetMatcher("menuAction.4711");
        MenuItemRidgetMatcherTest.assertTrue((boolean)matcher.matches(new Object[]{ridget}));
        matcher = new MenuItemRidgetMatcher("menuAction.*11");
        MenuItemRidgetMatcherTest.assertTrue((boolean)matcher.matches(new Object[]{ridget}));
        matcher = new MenuItemRidgetMatcher("4711");
        MenuItemRidgetMatcherTest.assertTrue((boolean)matcher.matches(new Object[]{ridget}));
    }
}

