/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.workarea;

import org.eclipse.riena.internal.navigation.ui.swt.workarea.SwtExtensionWorkareaDefinitionRegistry;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaDefinition;

@NonUITestCase
public class SwtExtensionWorkareaDefinitionRegistryTest
extends RienaTestCase {
    private static final String TEST_TYPE_ID = "TestTypeId";
    private static final String OTHER_TEST_TYPE_ID = "OtherTestTypeId";
    private static final boolean TEST_IS_VIEW_SHARED = true;
    private static final String TEST_VIEW_ID = "TestViewId";
    private static final boolean OTHER_TEST_IS_VIEW_SHARED = false;
    private static final String OTHER_TEST_VIEW_ID = "OtherTestViewId";
    private SwtExtensionWorkareaDefinitionRegistry workareaDefinitionRegistry;
    private IWorkareaDefinition workareaDefinition;

    protected void setUp() throws Exception {
        super.setUp();
        this.workareaDefinitionRegistry = new SwtExtensionWorkareaDefinitionRegistry();
        this.workareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)TEST_VIEW_ID, true);
    }

    public void testRegisterDefinition() throws Exception {
        this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, this.workareaDefinition);
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)this.workareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition((Object)TEST_TYPE_ID));
    }

    public void testRegisterSameDefinitionDifferentTypeId() throws Exception {
        this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, this.workareaDefinition);
        WorkareaDefinition otherWorkareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)TEST_VIEW_ID, true);
        this.workareaDefinitionRegistry.register((Object)OTHER_TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)this.workareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition((Object)TEST_TYPE_ID));
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)otherWorkareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition((Object)OTHER_TEST_TYPE_ID));
    }

    public void testRegisterSameDefinitionSameTypeId() throws Exception {
        this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, this.workareaDefinition);
        WorkareaDefinition otherWorkareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)TEST_VIEW_ID, true);
        this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
        SwtExtensionWorkareaDefinitionRegistryTest.assertSame((Object)this.workareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition((Object)TEST_TYPE_ID));
        SwtExtensionWorkareaDefinitionRegistryTest.assertNotSame((Object)otherWorkareaDefinition, (Object)this.workareaDefinitionRegistry.getDefinition((Object)TEST_TYPE_ID));
    }

    public void testRegisterDifferentDefinitionSameTypeId() throws Exception {
        this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, this.workareaDefinition);
        WorkareaDefinition otherWorkareaDefinition = null;
        try {
            otherWorkareaDefinition = new WorkareaDefinition(OtherTestSubModuleController.class, (Object)TEST_VIEW_ID, true);
            this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
            SwtExtensionWorkareaDefinitionRegistryTest.fail((String)"ApplicationModelFailure expected");
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            this.ok("ApplicationModelFailure expected");
        }
        try {
            otherWorkareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)OTHER_TEST_VIEW_ID, true);
            this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
            SwtExtensionWorkareaDefinitionRegistryTest.fail((String)"ApplicationModelFailure expected");
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            this.ok("ApplicationModelFailure expected");
        }
        try {
            otherWorkareaDefinition = new WorkareaDefinition(TestSubModuleController.class, (Object)TEST_VIEW_ID, false);
            this.workareaDefinitionRegistry.register((Object)TEST_TYPE_ID, (IWorkareaDefinition)otherWorkareaDefinition);
            SwtExtensionWorkareaDefinitionRegistryTest.fail((String)"ApplicationModelFailure expected");
        }
        catch (ApplicationModelFailure applicationModelFailure) {
            this.ok("ApplicationModelFailure expected");
        }
    }

    private static class OtherTestSubModuleController
    extends SubModuleController {
        private OtherTestSubModuleController() {
        }
    }

    private static class TestSubModuleController
    extends SubModuleController {
        private TestSubModuleController() {
        }
    }
}

