/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.beans.common.DoubleBean;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.DecimalTextRidget;
import org.eclipse.riena.tests.TestUtils;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class DecimalTextRidgetTest
extends AbstractSWTRidgetTest {
    protected IRidget createRidget() {
        return new DecimalTextRidget();
    }

    protected IDecimalTextRidget getRidget() {
        return (IDecimalTextRidget)super.getRidget();
    }

    protected Control createWidget(Composite parent) {
        Text result = new Text((Composite)this.getShell(), 133124);
        result.setData("type", (Object)"decimal");
        result.setLayoutData((Object)new RowData(100, -1));
        return result;
    }

    protected Text getWidget() {
        return (Text)super.getWidget();
    }

    public void testRidgetMapping() {
        DefaultSwtControlRidgetMapper mapper = new DefaultSwtControlRidgetMapper();
        DecimalTextRidgetTest.assertSame(DecimalTextRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testGroup() {
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,"), (String)DecimalTextRidget.group((String)this.localize("123456"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,78"), (String)DecimalTextRidget.group((String)this.localize("123456,78"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,78"), (String)DecimalTextRidget.group((String)this.localize("0,78"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,00001"), (String)DecimalTextRidget.group((String)this.localize("0,00001"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.000,00001"), (String)DecimalTextRidget.group((String)this.localize("1000,00001"), (boolean)true, (boolean)true));
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)DecimalTextRidget.group((String)this.localize(","), (boolean)true, (boolean)true));
    }

    public void testUngroup() {
        DecimalTextRidgetTest.assertEquals((String)this.localize("123456"), (String)DecimalTextRidget.ungroup((String)this.localize("123456")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123456,"), (String)DecimalTextRidget.ungroup((String)this.localize("123456,")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,45"), (String)DecimalTextRidget.ungroup((String)this.localize("123,45")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123456,78"), (String)DecimalTextRidget.ungroup((String)this.localize("123.456,78")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,0"), (String)DecimalTextRidget.ungroup((String)this.localize("0,0")));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,0123"), (String)DecimalTextRidget.ungroup((String)this.localize("0,0123")));
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)DecimalTextRidget.ungroup((String)this.localize(",")));
    }

    public void testSetText() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        ridget.setPrecision(2);
        Text control = this.getWidget();
        ridget.setText(this.localize("12345"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("12.345,"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("12.345"), (String)ridget.getText());
        ridget.setText(this.localize("3,145"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,145"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("3,145"), (String)ridget.getText());
        String lastText = ridget.getText();
        try {
            ridget.setText("abc");
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            DecimalTextRidgetTest.assertEquals((String)lastText, (String)control.getText());
            DecimalTextRidgetTest.assertEquals((String)lastText, (String)ridget.getText());
        }
    }

    public void testDeleteDecimalSeparator() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(4);
        ridget.setGrouping(true);
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setText(this.localize("1234,9876"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,9876"), (String)ridget.getText());
        control.setSelection(5, 5);
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
        UITestHelper.sendString(display, "\b");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)3, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setFocus();
        control.setSelection(4, 7);
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)4, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(4, 6);
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123,9876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)3, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(5, 7);
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(5, 10);
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.setSelection(0, 6);
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize(",9876"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)0, (int)control.getCaretPosition());
        ridget.setText(this.localize("1.234,9876"));
        control.selectAll();
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize(","), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize(""), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)0, (int)control.getCaretPosition());
    }

    public void testDeleteNegativeSign() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setSigned(true);
        ridget.setText(this.localize("1234,56"));
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMarkNegative());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,56"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setFocus();
        UITestHelper.sendString(display, "-");
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1.234,56"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)1, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
        control.setFocus();
        control.setSelection(0, 0);
        UITestHelper.sendKeyAction(display, 127);
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,56"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)0, (int)ridget.getMarkersOfType(NegativeMarker.class).size());
    }

    public void testReplaceSelection() throws Exception {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(2);
        ridget.setGrouping(true);
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(0, 7);
        UITestHelper.sendString(display, "9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("9,78"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(8, 10);
        UITestHelper.sendString(display, "9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,9"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.selectAll();
        UITestHelper.sendString(display, "1");
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((int)1, (int)control.getCaretPosition());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(6, 9);
        UITestHelper.sendString(display, "9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.459,8"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(6, 8);
        UITestHelper.sendString(display, "9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.459,78"), (String)ridget.getText());
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(7, 9);
        UITestHelper.sendString(display, "9");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,98"), (String)ridget.getText());
    }

    public void testJumpOverDecimalSeparator() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setGrouping(true);
        Text control = this.getWidget();
        Display display = control.getDisplay();
        ridget.setText(this.localize("123.456,78"));
        control.setSelection(7);
        UITestHelper.sendString(display, this.localize(","));
        DecimalTextRidgetTest.assertEquals((int)8, (int)control.getCaretPosition());
        control.setSelection(9);
        UITestHelper.sendString(display, this.localize(","));
        DecimalTextRidgetTest.assertEquals((int)9, (int)control.getCaretPosition());
        control.setSelection(6);
        UITestHelper.sendString(display, this.localize(","));
        DecimalTextRidgetTest.assertEquals((int)6, (int)control.getCaretPosition());
    }

    public void testDoubleValueProviderAndHighNumbers() {
        DoubleBean doubleValueBean = new DoubleBean(){

            public Double getValue() {
                return 1.0E15;
            }
        };
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(3);
        ridget.bindToModel((Object)doubleValueBean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.000.000.000.000.000"), (String)ridget.getText());
    }

    public void testDoubleValueProviderAndHighNumbersB() {
        DoubleBean doubleValueBean = new DoubleBean(){

            public Double getValue() {
                return 1.0E15;
            }
        };
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setMaxLength(16);
        ridget.setPrecision(3);
        ridget.bindToModel((Object)doubleValueBean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.000.000.000.000.000"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.000.000.000.000.000,000"), (String)this.getWidget().getText());
    }

    public void testUpdateFromModel() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(3);
        StringBean bean = new StringBean(this.localize("1,2"));
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((int)6, (int)ridget.getMaxLength());
        DecimalTextRidgetTest.assertEquals((int)3, (int)ridget.getPrecision());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,200"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,2"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,2"), (String)bean.getValue());
        bean.setValue(this.localize("0,0"));
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,0"), (String)bean.getValue());
        String oldControlValue = control.getText();
        String oldRidgetValue = ridget.getText();
        bean.setValue("abc");
        ridget.updateFromModel();
        DecimalTextRidgetTest.assertEquals((String)oldControlValue, (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)oldRidgetValue, (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)"abc", (String)bean.getValue());
    }

    public void testMaxLength() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(3);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), this.localize("123456,12345\r"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,123"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,123"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,123"), (String)bean.getValue());
    }

    public void testGetSetMaxLength() {
        IDecimalTextRidget ridget = this.getRidget();
        try {
            ridget.setMaxLength(0);
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setMaxLength(-1);
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        this.expectPropertyChangeEvent("maxLength", 10, 5);
        ridget.setMaxLength(5);
        this.verifyPropertyChangeEvents();
        DecimalTextRidgetTest.assertEquals((int)5, (int)ridget.getMaxLength());
        this.expectNoPropertyChangeEvent();
        ridget.setMaxLength(5);
        this.verifyPropertyChangeEvents();
    }

    public void testPrecision() throws Exception {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setMaxLength(6);
        ridget.setPrecision(3);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "123456\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "\b\b\b54321\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,543"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,543"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,543"), (String)bean.getValue());
        ridget.setPrecision(2);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,54"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,54"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,54"), (String)bean.getValue());
        ridget.setPrecision(0);
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456,"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("123.456"), (String)bean.getValue());
    }

    public void testGetSetPrecision() {
        IDecimalTextRidget ridget = this.getRidget();
        try {
            ridget.setPrecision(-1);
            DecimalTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        this.expectPropertyChangeEvent("precision", 2, 5);
        ridget.setPrecision(5);
        this.verifyPropertyChangeEvents();
        DecimalTextRidgetTest.assertEquals((int)5, (int)ridget.getPrecision());
        this.expectNoPropertyChangeEvent();
        ridget.setPrecision(5);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("precision", 5, 0);
        ridget.setPrecision(0);
        this.verifyPropertyChangeEvents();
        DecimalTextRidgetTest.assertEquals((int)0, (int)ridget.getPrecision());
    }

    public void testIsSetWithSign() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setPrecision(3);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isSigned());
        ridget.setSigned(true);
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isSigned());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "1-\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("-1"), (String)bean.getValue());
        ridget.setSigned(false);
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isSigned());
        control.selectAll();
        UITestHelper.sendString(control.getDisplay(), "1-\r");
        DecimalTextRidgetTest.assertEquals((String)this.localize("1,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1"), (String)bean.getValue());
    }

    public void testPadFractionDigitsOnFocusOut() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setPrecision(3);
        ridget.setSigned(true);
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), this.localize("1234\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), this.localize("\b,1\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,100"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,1"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,1"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), this.localize("\b,\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)bean.getValue());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), this.localize("\b,-\t"));
        DecimalTextRidgetTest.assertEquals((String)this.localize("0,000"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)ridget.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("0"), (String)bean.getValue());
    }

    public void testMandatoryMarker() {
        IDecimalTextRidget ridget = this.getRidget();
        ridget.setDirectWriting(true);
        Text control = this.getWidget();
        ridget.setMandatory(true);
        ridget.setText("");
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMandatory());
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "1");
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMandatory());
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        control.setFocus();
        UITestHelper.sendString(control.getDisplay(), "\b");
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isMandatory());
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testDisabledMarker() {
        IDecimalTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setText(this.localize("12,00"));
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        DecimalTextRidgetTest.assertEquals((String)this.localize("12,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        ridget.setEnabled(false);
        DecimalTextRidgetTest.assertFalse((boolean)ridget.isEnabled());
        DecimalTextRidgetTest.assertEquals((String)"", (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        ridget.setEnabled(true);
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        DecimalTextRidgetTest.assertEquals((String)this.localize("12,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)"12", (String)ridget.getText());
        ridget.setEnabled(false);
        ridget.setText(this.localize("1234,00"));
        ridget.setEnabled(true);
        DecimalTextRidgetTest.assertTrue((boolean)ridget.isEnabled());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234,00"), (String)control.getText());
        DecimalTextRidgetTest.assertEquals((String)this.localize("1.234"), (String)ridget.getText());
    }

    private String localize(String number) {
        return TestUtils.getLocalizedNumber(number);
    }
}

