/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MenuItemPropertiesTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testMenuItemProperties() {
        MenuItemRidget ridget = new MenuItemRidget();
        Menu menu = new Menu((Control)this.shell);
        new MenuItem(menu, 8);
        MenuItem item = new MenuItem(menu, 8);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)item, "item1");
        ridget.setUIControl((Object)item);
        MyMenuItemProperties itemProperties = new MyMenuItemProperties(ridget);
        MenuItemPropertiesTest.assertSame((Object)ridget, (Object)itemProperties.getRidget());
        MenuItemPropertiesTest.assertSame((Object)menu, (Object)itemProperties.getParent());
        MenuItemPropertiesTest.assertEquals((int)1, (int)itemProperties.getIndex());
    }

    public void testCreateItemParent() {
        MenuItemRidget ridget = new MenuItemRidget();
        Menu menu = new Menu((Control)this.shell);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("MenuItem0815");
        ridget.setUIControl((Object)item);
        MyMenuItemProperties itemProperties = new MyMenuItemProperties(ridget);
        Menu menu2 = new Menu((Control)this.shell);
        MenuItem item2 = itemProperties.createItem(menu2);
        MenuItemPropertiesTest.assertSame((Object)item2, (Object)ridget.getUIControl());
        MenuItemPropertiesTest.assertSame((Object)menu2, (Object)item2.getParent());
        MenuItemPropertiesTest.assertEquals((String)item.getText(), (String)item2.getText());
    }

    public void testCreateItem() {
        MenuItemRidget ridget = new MenuItemRidget();
        Menu menu = new Menu((Control)this.shell);
        MenuItem item = new MenuItem(menu, 8);
        String text = "MenuItem0815";
        item.setText(text);
        ridget.setUIControl((Object)item);
        MyMenuItemProperties itemProperties = new MyMenuItemProperties(ridget);
        item.dispose();
        MenuItemPropertiesTest.assertEquals((int)0, (int)menu.getItemCount());
        MenuItem item2 = itemProperties.createItem();
        MenuItemPropertiesTest.assertSame((Object)item2, (Object)ridget.getUIControl());
        MenuItemPropertiesTest.assertSame((Object)menu, (Object)item2.getParent());
        MenuItemPropertiesTest.assertEquals((int)1, (int)menu.getItemCount());
        MenuItemPropertiesTest.assertEquals((String)text, (String)item2.getText());
    }

    private static class MyMenuItemProperties
    extends MenuItemProperties {
        public MyMenuItemProperties(MenuItemRidget ridget) {
            super(ridget);
        }

        public Menu getParent() {
            return super.getParent();
        }

        public int getIndex() {
            return super.getIndex();
        }

        public MenuItemRidget getRidget() {
            return super.getRidget();
        }

        public MenuItem createItem(Menu parent) {
            return super.createItem(parent);
        }

        public MenuItem createItem() {
            return super.createItem();
        }
    }
}

