/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.internal.ui.ridgets.swt.SegmentedString;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class SegmentedStringTest
extends RienaTestCase {
    public void testCreateSegmentedString() {
        SegmentedString ss = new SegmentedString("dd.MM.yyyy");
        SegmentedStringTest.assertEquals((String)"dd|dd|dddd", (String)ss.getPattern());
        SegmentedStringTest.assertEquals((String)"  .  .    ", (String)ss.toString());
        ss = new SegmentedString("MM/dd/yyyy");
        SegmentedStringTest.assertEquals((String)"dd|dd|dddd", (String)ss.getPattern());
        SegmentedStringTest.assertEquals((String)"  /  /    ", (String)ss.toString());
        ss = new SegmentedString("HH:mm");
        SegmentedStringTest.assertEquals((String)"dd|dd", (String)ss.getPattern());
        SegmentedStringTest.assertEquals((String)"  :  ", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy HH:mm");
        SegmentedStringTest.assertEquals((String)"dd|dd|dddd|dd|dd", (String)ss.getPattern());
        SegmentedStringTest.assertEquals((String)"  .  .       :  ", (String)ss.toString());
        try {
            new SegmentedString("ddabcMM");
            SegmentedStringTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testInsert() {
        SegmentedString ss = new SegmentedString("dd.MM.yyyy", "10.10. 200");
        ss.insert(10, "8");
        SegmentedStringTest.assertEquals((String)"10.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10.10. 200");
        ss.insert(9, "1");
        SegmentedStringTest.assertEquals((String)"10.10.2010", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10.10. 200");
        ss.insert(8, "1");
        SegmentedStringTest.assertEquals((String)"10.10.2100", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10.10. 200");
        ss.insert(7, "1");
        SegmentedStringTest.assertEquals((String)"10.10.1200", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10.10. 200");
        ss.insert(6, "1");
        SegmentedStringTest.assertEquals((String)"10.10.1200", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10.10.2008");
        ss.insert(5, "1");
        SegmentedStringTest.assertEquals((String)"10.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10. 1.2008");
        ss.insert(5, "1");
        SegmentedStringTest.assertEquals((String)"10.11.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10. 1.2008");
        ss.insert(4, "2");
        SegmentedStringTest.assertEquals((String)"10.21.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "10. 1. 008");
        ss.insert(5, "23");
        SegmentedStringTest.assertEquals((String)"10.12.3008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .  .    ");
        ss.insert(1, "01102008");
        SegmentedStringTest.assertEquals((String)"01.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .  .    ");
        ss.insert(1, "01.10.2008");
        SegmentedStringTest.assertEquals((String)"01.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .10.2008");
        ss.insert(1, "1208");
        SegmentedStringTest.assertEquals((String)"12.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .  .2008");
        ss.insert(1, "1208");
        SegmentedStringTest.assertEquals((String)"12.08.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .  .2008");
        ss.insert(4, "1208");
        SegmentedStringTest.assertEquals((String)"  .12.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "01.  .2008");
        ss.insert(6, "10");
        SegmentedStringTest.assertEquals((String)"01.  .2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .  .    ");
        ss.insert(6, "2008");
        SegmentedStringTest.assertEquals((String)"  .  .2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .  .    ");
        ss.insert(3, "102008");
        SegmentedStringTest.assertEquals((String)"  .10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "12. 1.2008");
        ss.insert(5, "0");
        SegmentedStringTest.assertEquals((String)"12.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", " 1.10.2008");
        ss.insert(2, "2");
        SegmentedStringTest.assertEquals((String)"12.10.2008", (String)ss.toString());
    }

    public void testDelete() {
        SegmentedString ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        int cursor = ss.delete(5, 5);
        SegmentedStringTest.assertEquals((String)"01.10.2008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)5, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        cursor = ss.delete(5, 6);
        SegmentedStringTest.assertEquals((String)"01.10. 008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)5, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        cursor = ss.delete(4, 5);
        SegmentedStringTest.assertEquals((String)"01. 1.2008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)5, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        cursor = ss.delete(4, 6);
        SegmentedStringTest.assertEquals((String)"01. 1. 008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)5, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        cursor = ss.delete(0, 9);
        SegmentedStringTest.assertEquals((String)"  .  .    ", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)2, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        cursor = ss.delete(0, 6);
        SegmentedStringTest.assertEquals((String)"  .  . 008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)2, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "12.10.2008");
        cursor = ss.delete(0, 0);
        SegmentedStringTest.assertEquals((String)" 2.10.2008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)1, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "12.10.2008");
        cursor = ss.delete(1, 1);
        SegmentedStringTest.assertEquals((String)" 1.10.2008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)2, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "12.10.2008");
        cursor = ss.delete(3, 3);
        SegmentedStringTest.assertEquals((String)"12. 0.2008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)4, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "12.10.2008");
        cursor = ss.delete(4, 4);
        SegmentedStringTest.assertEquals((String)"12. 1.2008", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)5, (int)cursor);
        ss = new SegmentedString("dd.MM.yyyy", "12.10.2008");
        cursor = ss.delete(7, 8);
        SegmentedStringTest.assertEquals((String)"12.10.  28", (String)ss.toString());
        SegmentedStringTest.assertEquals((int)9, (int)cursor);
    }

    public void testReplace() {
        SegmentedString ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        ss.replace(5, 5, "1");
        SegmentedStringTest.assertEquals((String)"01.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        ss.replace(5, 6, "1");
        SegmentedStringTest.assertEquals((String)"01.10.1008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        ss.replace(4, 5, "1");
        SegmentedStringTest.assertEquals((String)"01.11.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        ss.replace(4, 6, "1");
        SegmentedStringTest.assertEquals((String)"01.11. 008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        ss.replace(0, 6, "3");
        SegmentedStringTest.assertEquals((String)" 3.  . 008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "01.10.2008");
        ss.replace(0, 9, "3");
        SegmentedStringTest.assertEquals((String)" 3.  .    ", (String)ss.toString());
    }

    public void testShiftSpacesLeft() {
        SegmentedString ss = new SegmentedString("dd.MM.yyyy", "01.10.200 ");
        ss.shiftSpacesLeft(-1);
        SegmentedStringTest.assertEquals((String)"01.10. 200", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "01.1 .2008");
        ss.shiftSpacesLeft(-1);
        SegmentedStringTest.assertEquals((String)"01. 1.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "0 .10.2008");
        ss.shiftSpacesLeft(-1);
        SegmentedStringTest.assertEquals((String)" 0.10.2008", (String)ss.toString());
        ss = new SegmentedString("dd.MM.yyyy", "  .  .    ");
        ss.shiftSpacesLeft(-1);
        SegmentedStringTest.assertEquals((String)"  .  .    ", (String)ss.toString());
    }
}

