/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.riena.tests.FTActionListener;
import org.eclipse.riena.tests.UITestHelper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableRidgetTest
extends AbstractTableRidgetTest {
    protected Control createWidget(Composite parent) {
        Table table = new Table(parent, 2);
        table.setHeaderVisible(true);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        return table;
    }

    protected IRidget createRidget() {
        return new TableRidget();
    }

    protected Table getWidget() {
        return (Table)super.getWidget();
    }

    protected TableRidget getRidget() {
        return (TableRidget)super.getRidget();
    }

    protected void bindRidgetToModel() {
        this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, new String[]{"firstname", "lastname"}, new String[]{"First Name", "Last Name"});
    }

    public void testRidgetMapping() {
        DefaultSwtControlRidgetMapper mapper = new DefaultSwtControlRidgetMapper();
        TableRidgetTest.assertSame(TableRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testBindToModel() {
        Table control = this.getWidget();
        TableRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
        TableRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(1).getText(0));
        TableRidgetTest.assertEquals((String)this.person3.getFirstname(), (String)control.getItem(2).getText(0));
        TableRidgetTest.assertEquals((String)this.person1.getLastname(), (String)control.getItem(0).getText(1));
        TableRidgetTest.assertEquals((String)this.person2.getLastname(), (String)control.getItem(1).getText(1));
        TableRidgetTest.assertEquals((String)this.person3.getLastname(), (String)control.getItem(2).getText(1));
    }

    public void testBindToModelTooFewColumns() {
        Table control = this.getWidget();
        TableRidgetTest.assertEquals((int)2, (int)control.getColumnCount());
        try {
            this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, new String[]{"firstname"}, new String[]{"First Name"});
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testBindToModelWithTooManyColumns() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        TableRidgetTest.assertEquals((int)2, (int)control.getColumnCount());
        try {
            ridget.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"firstname", "lastname", "listEntry"}, new String[]{"First Name", "Last Name", "First - Last"});
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setUIControl((Object)new Table((Composite)this.getShell(), 0));
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testTableColumnsNumAndHeader() {
        Table control = this.getWidget();
        TableColumn[] columns = control.getColumns();
        TableRidgetTest.assertEquals((int)2, (int)columns.length);
        TableRidgetTest.assertEquals((String)"First Name", (String)columns[0].getText());
        TableRidgetTest.assertEquals((String)"Last Name", (String)columns[1].getText());
        TableRidgetTest.assertTrue((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsNumAndHeaderWithMismatch() {
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] headers1 = new String[]{"First Name"};
        try {
            this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, properties1, headers1);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testTableColumnsWithNullHeader() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        control.setHeaderVisible(true);
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, properties1, null);
        TableRidgetTest.assertFalse((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsWithNullHeaderEntry() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] stringArray = new String[2];
        stringArray[0] = "First Name";
        String[] headers = stringArray;
        ridget.bindToModel((Object)this.manager, "persons", Person.class, properties1, headers);
        TableRidgetTest.assertEquals((String)"First Name", (String)control.getColumn(0).getText());
        TableRidgetTest.assertEquals((String)"", (String)control.getColumn(1).getText());
    }

    public void testUpdateFromModel() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        final ArrayList changeEvents = new ArrayList();
        IChangeListener listener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                changeEvents.add(event);
            }
        };
        ridget.getObservableList().addChangeListener(listener);
        int oldCount = this.manager.getPersons().size();
        TableRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        TableRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        this.manager.getPersons().remove(this.person1);
        int newCount = oldCount - 1;
        TableRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        TableRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        TableRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        TableRidgetTest.assertEquals((int)0, (int)changeEvents.size());
        ridget.updateFromModel();
        TableRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        TableRidgetTest.assertEquals((int)newCount, (int)ridget.getObservableList().size());
        TableRidgetTest.assertEquals((int)newCount, (int)control.getItemCount());
        TableRidgetTest.assertEquals((int)1, (int)changeEvents.size());
    }

    public void testUpdateFromModelPreservesSelection() {
        TableRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        TableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person1);
        ridget.updateFromModel();
        TableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
    }

    public void testUpdateFromModelRemovesSelection() {
        TableRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        TableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        TableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testContainsOption() {
        TableRidget ridget = this.getRidget();
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        TableRidgetTest.assertFalse((boolean)ridget.containsOption(null));
        TableRidgetTest.assertFalse((boolean)ridget.containsOption((Object)new Person("", "")));
        List<Person> persons = Arrays.asList(this.person3);
        PersonManager manager = new PersonManager(persons);
        this.getRidget().bindToModel((Object)manager, "persons", Person.class, new String[]{"firstname", "lastname"}, null);
        TableRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person1));
        TableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
    }

    public void testSetSelectionType() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        TableRidgetTest.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        TableRidgetTest.assertTrue(((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        ridget.setSelection(nArray);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices().length);
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        ridget.setSelection(nArray2);
        TableRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices().length);
        TableRidgetTest.assertEquals((int)2, (int)control.getSelectionCount());
    }

    public void testAddDoubleClickListener() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        try {
            ridget.addDoubleClickListener(null);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTActionListener listener1 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener1);
        FTActionListener listener2 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener2);
        ridget.addDoubleClickListener((IActionListener)listener2);
        Event doubleClick = new Event();
        doubleClick.widget = control;
        doubleClick.type = 8;
        control.notifyListeners(8, doubleClick);
        TableRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        TableRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeDoubleClickListener((IActionListener)listener1);
        control.notifyListeners(8, doubleClick);
        TableRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testSetComparator() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        StringComparator comparator = new StringComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparator);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setComparator(2, (Comparator)comparator);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setSortedAscending(true);
        int lastItemIndex = control.getItemCount() - 1;
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, (Comparator)comparator);
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedColumn(0);
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, null);
        TableRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(1, (Comparator)comparator);
        ridget.setSortedColumn(1);
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(1));
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(1));
        ridget.setSortedAscending(false);
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0).getText(1));
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex).getText(1));
    }

    public void testGetSortedColumn() {
        TableRidget ridget = this.getRidget();
        try {
            ridget.setSortedColumn(2);
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new StringComparator());
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(1, (Comparator)new StringComparator());
        ridget.setSortedColumn(1);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        TableRidget ridget = this.getRidget();
        try {
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(2));
            TableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int i = 0;
        while (i < 2) {
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, (Comparator)new StringComparator());
            TableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, false);
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, true);
            TableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, null);
            TableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ++i;
        }
    }

    public void testSetSortedAscending() {
        Table control = this.getWidget();
        TableRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"lastname", "firstname"}, null);
        int lastItemIndex = control.getItemCount() - 1;
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new StringComparator());
        ridget.setSortedColumn(0);
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedAscending(false);
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedAscending(true);
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        TableRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(0));
        TableRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, null);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        TableRidget ridget = this.getRidget();
        ridget.setSortedAscending(true);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        TableRidget ridget = this.getRidget();
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, 1));
        ridget.setSortedColumn(1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetColumnSortabilityFiresEvents() {
        TableRidget ridget = this.getRidget();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
    }

    public void testColumnHeaderChangesSortability() {
        TableRidget ridget = this.getRidget();
        Table table = this.getWidget();
        ridget.setColumnSortable(0, true);
        ridget.setComparator(0, (Comparator)new StringComparator());
        ridget.setColumnSortable(1, true);
        ridget.setComparator(1, (Comparator)new StringComparator());
        ridget.setSortedColumn(-1);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        Event e = new Event();
        e.type = 13;
        e.widget = table.getColumn(0);
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        TableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        TableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testSetMoveableColumns() {
        TableRidget ridget = this.getRidget();
        Table table = this.getWidget();
        TableRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        TableRidgetTest.assertFalse((boolean)table.getColumn(0).getMoveable());
        TableRidgetTest.assertFalse((boolean)table.getColumn(1).getMoveable());
        ridget.setMoveableColumns(true);
        TableRidgetTest.assertTrue((boolean)ridget.hasMoveableColumns());
        TableRidgetTest.assertTrue((boolean)table.getColumn(0).getMoveable());
        TableRidgetTest.assertTrue((boolean)table.getColumn(1).getMoveable());
        ridget.setMoveableColumns(false);
        TableRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        TableRidgetTest.assertFalse((boolean)table.getColumn(0).getMoveable());
        TableRidgetTest.assertFalse((boolean)table.getColumn(1).getMoveable());
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        TableRidget ridget = this.getRidget();
        Table control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000002);
        UITestHelper.sendKeyAction(control.getDisplay(), 0x1000001);
        TableRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        TableRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        TableRidget ridget = this.getRidget();
        ridget.setSelection(0);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(true);
        TableRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setSelection(null);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(false);
        TableRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
    }

    protected void clearUIControlRowSelection() {
        this.getWidget().deselectAll();
        this.fireSelectionEvent();
    }

    protected int getUIControlSelectedRowCount() {
        return this.getWidget().getSelectionCount();
    }

    protected int getUIControlSelectedRow() {
        return this.getWidget().getSelectionIndex();
    }

    protected Object getRowValue(int i) {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        return rowObservables.get(i);
    }

    protected int[] getSelectedRows() {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        Object[] elements = this.getRidget().getMultiSelectionObservable().toArray();
        int[] result = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            result[i] = rowObservables.indexOf(element);
            ++i;
        }
        return result;
    }

    protected int[] getUIControlSelectedRows() {
        return this.getWidget().getSelectionIndices();
    }

    protected void setUIControlRowSelection(int[] indices) {
        this.getWidget().setSelection(indices);
        this.fireSelectionEvent();
    }

    protected void setUIControlRowSelectionInterval(int start, int end) {
        this.getWidget().setSelection(start, end);
        this.fireSelectionEvent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Comparator<Object>,
    Serializable {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

