/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.ToggleButtonRidget;
import org.eclipse.riena.tests.FTActionListener;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ToggleButtonRidgetTest
extends AbstractSWTRidgetTest {
    private static final String PLUGIN_ID = "org.eclipse.riena.tests:";
    private static final String ICON_ECLIPSE = "org.eclipse.riena.tests:/icons/eclipse.gif";
    private static final String LABEL = "testlabel";
    private static final String LABEL2 = "testlabel2";

    protected IToggleButtonRidget createRidget() {
        return new ToggleButtonRidget();
    }

    protected Button createWidget(Composite parent) {
        return new Button(parent, 32);
    }

    protected IToggleButtonRidget getRidget() {
        return (IToggleButtonRidget)super.getRidget();
    }

    protected Button getWidget() {
        return (Button)super.getWidget();
    }

    public void testRidgetMapping() {
        Shell shell = this.getShell();
        DefaultSwtControlRidgetMapper mapper = new DefaultSwtControlRidgetMapper();
        Button buttonToggle = new Button((Composite)shell, 2);
        ToggleButtonRidgetTest.assertSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)buttonToggle));
        Button buttonCheck = new Button((Composite)shell, 32);
        ToggleButtonRidgetTest.assertSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)buttonCheck));
        Button buttonPush = new Button((Composite)shell, 8);
        ToggleButtonRidgetTest.assertNotSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)buttonPush));
        Button aButton = new Button((Composite)shell, 0);
        ToggleButtonRidgetTest.assertNotSame(ToggleButtonRidget.class, (Object)mapper.getRidgetClass((Object)aButton));
    }

    public void testSetUIControl() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        ToggleButtonRidgetTest.assertSame((Object)button, (Object)ridget.getUIControl());
    }

    public void testSetSelected() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        BooleanTestBean model = new BooleanTestBean();
        IObservableValue modelOV = BeansObservables.observeValue((Object)model, (String)"selected");
        ridget.bindToModel(modelOV);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)button.getSelection());
        ridget.setSelected(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)button.getSelection());
    }

    public void testIsSelected() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        BooleanTestBean model = new BooleanTestBean();
        model.setSelected(true);
        IObservableValue modelOV = BeansObservables.observeValue((Object)model, (String)"selected");
        ridget.bindToModel(modelOV);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
    }

    public void testBindToModelIObservableValue() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        BooleanTestBean model = new BooleanTestBean();
        model.setSelected(true);
        IObservableValue modelOV = BeansObservables.observeValue((Object)model, (String)"selected");
        ridget.bindToModel(modelOV);
        ToggleButtonRidgetTest.assertNotNull((Object)BeansObservables.observeValue((Object)ridget, (String)"selected"));
        ToggleButtonRidgetTest.assertEquals(Boolean.TYPE, (Object)BeansObservables.observeValue((Object)ridget, (String)"selected").getValueType());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
    }

    public void testBindToModelPropertyName() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        BooleanTestBean model = new BooleanTestBean();
        model.setSelected(true);
        ridget.bindToModel((Object)model, "selected");
        ToggleButtonRidgetTest.assertNotNull((Object)BeansObservables.observeValue((Object)ridget, (String)"selected"));
        ToggleButtonRidgetTest.assertEquals(Boolean.TYPE, (Object)BeansObservables.observeValue((Object)ridget, (String)"selected").getValueType());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
    }

    public void testUpdateFromModel() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        BooleanTestBean model = new BooleanTestBean();
        model.setSelected(true);
        ridget.bindToModel((Object)model, "selected");
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)button.getSelection());
        model.setSelected(false);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertFalse((boolean)button.getSelection());
    }

    public void testActionListener() {
        IToggleButtonRidget ridget = this.getRidget();
        ridget.setSelected(false);
        FTActionListener listener = new FTActionListener();
        ridget.addListener((IActionListener)listener);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertEquals((int)1, (int)listener.getCount());
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertEquals((int)1, (int)listener.getCount());
        ridget.setSelected(false);
        ToggleButtonRidgetTest.assertEquals((int)2, (int)listener.getCount());
        ridget.removeListener((IActionListener)listener);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertEquals((int)2, (int)listener.getCount());
        try {
            ridget.addListener(null);
            ToggleButtonRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public final void testSetText() throws Exception {
        IToggleButtonRidget ridget = this.getRidget();
        Button button = this.getWidget();
        ridget.setText("");
        ToggleButtonRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)"", (String)button.getText());
        try {
            ridget.setText(null);
            ToggleButtonRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        ridget.setText(LABEL);
        ToggleButtonRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)LABEL, (String)button.getText());
        ridget.setUIControl(null);
        ridget.setText(LABEL2);
        ToggleButtonRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)LABEL, (String)button.getText());
        ridget.setUIControl((Object)button);
        ToggleButtonRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)LABEL2, (String)button.getText());
    }

    public final void testSetIcon() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setIcon(ICON_ECLIPSE);
        ToggleButtonRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)ridget.getIcon());
        ToggleButtonRidgetTest.assertNotNull((Object)control.getImage());
        ridget.setIcon(null);
        ToggleButtonRidgetTest.assertNull((Object)ridget.getIcon());
        ToggleButtonRidgetTest.assertNull((Object)control.getImage());
        ridget.setIcon("nonsense");
        Image missingImage = (Image)ReflectionUtils.invokeHidden((Object)ridget, (String)"getMissingImage", (Object[])new Object[0]);
        ToggleButtonRidgetTest.assertEquals((String)"nonsense", (String)ridget.getIcon());
        ToggleButtonRidgetTest.assertEquals((Object)missingImage, (Object)control.getImage());
        Button button = this.createWidget((Composite)this.getShell());
        Image buttonImage = button.getDisplay().getSystemImage(2);
        button.setImage(buttonImage);
        IToggleButtonRidget buttonRidget = this.createRidget();
        buttonRidget.setUIControl((Object)button);
        ToggleButtonRidgetTest.assertSame((Object)buttonImage, (Object)button.getImage());
        buttonRidget.setIcon(null);
        ToggleButtonRidgetTest.assertNull((Object)buttonRidget.getIcon());
        ToggleButtonRidgetTest.assertNull((Object)button.getImage());
        buttonRidget.setIcon(ICON_ECLIPSE);
        ToggleButtonRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)buttonRidget.getIcon());
        ToggleButtonRidgetTest.assertNotNull((Object)button.getImage());
        ToggleButtonRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
        button = this.createWidget((Composite)this.getShell());
        button.setImage(buttonImage);
        buttonRidget = this.createRidget();
        buttonRidget.setIcon(ICON_ECLIPSE);
        buttonRidget.setUIControl((Object)button);
        ToggleButtonRidgetTest.assertNotNull((Object)button.getImage());
        ToggleButtonRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
    }

    public final void testInitText() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ReflectionUtils.setHidden((Object)ridget, (String)"textAlreadyInitialized", (Object)false);
        ReflectionUtils.setHidden((Object)ridget, (String)"text", null);
        control.setText("Hello!");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        ToggleButtonRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)"Hello!", (String)control.getText());
        ToggleButtonRidgetTest.assertTrue((boolean)((Boolean)ReflectionUtils.getHidden((Object)ridget, (String)"textAlreadyInitialized")));
        control.setText("World");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        ToggleButtonRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        ToggleButtonRidgetTest.assertEquals((String)"World", (String)control.getText());
    }

    public void testOutputRidgetNotVisible() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setOutputOnly(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isVisible());
        ridget.setOutputOnly(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setOutputOnly(true);
        ridget.setVisible(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isVisible());
        ridget.setVisible(false);
        ridget.setOutputOnly(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isVisible());
        ridget.setVisible(true);
        ridget.setOutputOnly(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isVisible());
        ridget.setVisible(false);
        ridget.setOutputOnly(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isVisible());
        ridget.setVisible(true);
        ridget.setOutputOnly(true);
        ridget.setVisible(false);
        ridget.setVisible(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isVisible());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isVisible());
    }

    public void testDisabledRidgetDoesNotCheckControlOnRidgetSelection() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        BooleanTestBean model = new BooleanTestBean();
        ridget.bindToModel((Object)model, "selected");
        ridget.setSelected(false);
        ridget.setEnabled(false);
        ToggleButtonRidgetTest.assertFalse((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    public void testDisabledRidgetDoesNotCheckControlOnModelSelection() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        BooleanTestBean model = new BooleanTestBean();
        ridget.bindToModel((Object)model, "selected");
        ridget.setEnabled(false);
        model.setSelected(false);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertFalse((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        model.setSelected(true);
        ridget.updateFromModel();
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)model.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    public void testDisableRidgetRemovesSelection() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setEnabled(true);
        ridget.setSelected(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        ridget.setEnabled(false);
        ToggleButtonRidgetTest.assertFalse((boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertFalse((boolean)control.isEnabled());
        if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)ridget.isSelected());
        ToggleButtonRidgetTest.assertTrue((boolean)control.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    public void testDisabledDoesNotFireSelected() {
        IToggleButtonRidget ridget = this.getRidget();
        ridget.setEnabled(true);
        ridget.setSelected(true);
        ridget.addPropertyChangeListener("selected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ToggleButtonRidgetTest.fail((String)("Unexpected property change event: " + evt));
            }
        });
        ridget.setEnabled(false);
        ridget.setEnabled(true);
    }

    public void testDisableAndClearOnBind() {
        IToggleButtonRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        ridget.setSelected(true);
        ridget.setUIControl((Object)control);
        ToggleButtonRidgetTest.assertFalse((boolean)control.isEnabled());
        if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            ToggleButtonRidgetTest.assertFalse((boolean)control.getSelection());
        } else {
            ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
        }
        ridget.setEnabled(true);
        ToggleButtonRidgetTest.assertTrue((boolean)control.isEnabled());
        ToggleButtonRidgetTest.assertTrue((boolean)control.getSelection());
    }

    private static class BooleanTestBean {
        private boolean selected;

        private BooleanTestBean() {
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

