/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidgetLabelProvider;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

@UITestCase
public class TreeRidgetLabelProviderTest
extends TestCase {
    private static final String[] COLUMN_PROPERTIES = new String[]{"word", "upperCase"};
    private Shell shell;
    private TreeViewer viewer;
    private TreeRidgetLabelProvider labelProvider;
    private WordNode node;
    private WordNode leaf;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        Shell aShell = new Shell(display);
        this.viewer = new TreeViewer(this.createTree(aShell));
        IObservableSet elements = this.createElements();
        this.labelProvider = TreeRidgetLabelProvider.createLabelProvider((TreeViewer)this.viewer, WordNode.class, (IObservableSet)elements, (String[])COLUMN_PROPERTIES, null);
        this.viewer.setContentProvider((IContentProvider)new FTTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)elements.toArray());
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    public void testGetText() {
        TreeRidgetLabelProviderTest.assertEquals((String)"Node", (String)this.labelProvider.getText((Object)this.node));
        TreeRidgetLabelProviderTest.assertEquals((String)"LEAF", (String)this.labelProvider.getText((Object)this.leaf));
    }

    public void testGetColumnText() {
        TreeRidgetLabelProviderTest.assertEquals((String)"Node", (String)this.labelProvider.getColumnText((Object)this.node, 0));
        TreeRidgetLabelProviderTest.assertEquals((String)"LEAF", (String)this.labelProvider.getColumnText((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertEquals((String)"false", (String)this.labelProvider.getColumnText((Object)this.node, 1));
        TreeRidgetLabelProviderTest.assertEquals((String)"true", (String)this.labelProvider.getColumnText((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertEquals(null, (String)this.labelProvider.getColumnText((Object)this.node, 99));
    }

    public void testGetImage() {
        this.viewer.collapseAll();
        Image siCollapsed = Activator.getSharedImage((String)"IMG_NODE_COLLAPSED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siCollapsed);
        Image nodeCollapsed = this.labelProvider.getImage((Object)this.node);
        TreeRidgetLabelProviderTest.assertSame((Object)siCollapsed, (Object)nodeCollapsed);
        this.viewer.expandAll();
        Image siExpanded = Activator.getSharedImage((String)"IMG_NODE_EXPANDED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siExpanded);
        Image nodeExpanded = this.labelProvider.getImage((Object)this.node);
        TreeRidgetLabelProviderTest.assertSame((Object)siExpanded, (Object)nodeExpanded);
        this.viewer.collapseToLevel((Object)this.node, 1);
        TreeRidgetLabelProviderTest.assertSame((Object)siCollapsed, (Object)this.labelProvider.getImage((Object)this.node));
        this.viewer.expandToLevel((Object)this.node, 1);
        TreeRidgetLabelProviderTest.assertSame((Object)siExpanded, (Object)this.labelProvider.getImage((Object)this.node));
        Image siLeaf = Activator.getSharedImage((String)"IMG_LEAF");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siLeaf);
        Image imgLeaf = this.labelProvider.getImage((Object)this.leaf);
        TreeRidgetLabelProviderTest.assertSame((Object)siLeaf, (Object)imgLeaf);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeExpanded, (Object)nodeCollapsed);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeExpanded, (Object)imgLeaf);
        TreeRidgetLabelProviderTest.assertNotSame((Object)nodeCollapsed, (Object)imgLeaf);
    }

    public void testGetColumnImage() {
        this.viewer.collapseAll();
        Image siCollapsed = Activator.getSharedImage((String)"IMG_NODE_COLLAPSED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siCollapsed);
        TreeRidgetLabelProviderTest.assertSame((Object)siCollapsed, (Object)this.labelProvider.getColumnImage((Object)this.node, 0));
        Image siLeaf = Activator.getSharedImage((String)"IMG_LEAF");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siLeaf);
        TreeRidgetLabelProviderTest.assertSame((Object)siLeaf, (Object)this.labelProvider.getColumnImage((Object)this.leaf, 0));
        TreeRidgetLabelProviderTest.assertNotSame((Object)siLeaf, (Object)siCollapsed);
        Image siUnchecked = Activator.getSharedImage((String)"IMG_UNCHECKED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siUnchecked);
        TreeRidgetLabelProviderTest.assertEquals((Object)siUnchecked, (Object)this.labelProvider.getColumnImage((Object)this.node, 1));
        Image siChecked = Activator.getSharedImage((String)"IMG_CHECKED");
        TreeRidgetLabelProviderTest.assertNotNull((Object)siChecked);
        TreeRidgetLabelProviderTest.assertEquals((Object)siChecked, (Object)this.labelProvider.getColumnImage((Object)this.leaf, 1));
        TreeRidgetLabelProviderTest.assertNotSame((Object)siChecked, (Object)siUnchecked);
        TreeRidgetLabelProviderTest.assertEquals(null, (Object)this.labelProvider.getColumnImage((Object)this.node, 99));
    }

    public void testGetForeground() {
        WordNode wordNode = new WordNode("test");
        this.labelProvider = TreeRidgetLabelProvider.createLabelProvider((TreeViewer)this.viewer, WordNode.class, (IObservableSet)this.createElements(), (String[])COLUMN_PROPERTIES, (String)"upperCase");
        wordNode.setUpperCase(true);
        Color colorEnabled = this.labelProvider.getForeground((Object)wordNode);
        TreeRidgetLabelProviderTest.assertNull((Object)colorEnabled);
        wordNode.setUpperCase(false);
        Color colorDisabled = this.labelProvider.getForeground((Object)wordNode);
        TreeRidgetLabelProviderTest.assertNotNull((Object)colorDisabled);
    }

    private IObservableSet createElements() {
        ArrayList<WordNode> collection = new ArrayList<WordNode>();
        this.node = new WordNode("Node");
        new WordNode(this.node, "Alpha");
        new WordNode(this.node, "Bravo");
        this.leaf = new WordNode("Leaf");
        this.leaf.setUpperCase(true);
        collection.add(this.node);
        collection.add(this.leaf);
        WritableSet elements = new WritableSet(Realm.getDefault(), collection, WordNode.class);
        return elements;
    }

    private Tree createTree(Shell shell) {
        shell.setLayout((Layout)new FillLayout());
        Tree result = new Tree((Composite)shell, 2052);
        TreeColumn tc1 = new TreeColumn(result, 0);
        tc1.setWidth(200);
        TreeColumn tc2 = new TreeColumn(result, 0);
        tc2.setWidth(200);
        return result;
    }

    private static final class FTTreeContentProvider
    implements ITreeContentProvider {
        private FTTreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            return ((WordNode)element).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((WordNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((WordNode)element).getChildren().size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

