/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.ShellRidget;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class ModuleControllerTest
extends TestCase {
    public void testAfterBind() throws Exception {
        ModuleNode node = new ModuleNode();
        node.setClosable(true);
        node.setLabel("Hello");
        ModuleController controller = new ModuleController((IModuleNode)node);
        ShellRidget shellRidget = new ShellRidget();
        Shell shell = new Shell();
        shellRidget.setUIControl((Object)shell);
        controller.setWindowRidget((IWindowRidget)shellRidget);
        controller.afterBind();
        ModuleControllerTest.assertTrue((boolean)controller.isCloseable());
        ModuleControllerTest.assertEquals((String)"Hello", (String)shellRidget.getTitle());
        node.setClosable(false);
        controller.configureRidgets();
        ModuleControllerTest.assertFalse((boolean)controller.isCloseable());
        shell.dispose();
    }

    public void testGetVisibleChildren() {
        ModuleNode node = new ModuleNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubModuleNode sub1 = new SubModuleNode();
        node.addChild((INavigationNode)sub1);
        SubModuleNode sub2 = new SubModuleNode();
        node.addChild((INavigationNode)sub2);
        SubModuleNode sub3 = new SubModuleNode();
        node.addChild((INavigationNode)sub3);
        ModuleController controller = new ModuleController((IModuleNode)node);
        List nodes = controller.getVisibleChildren((INavigationNode)node);
        ModuleControllerTest.assertEquals((int)3, (int)nodes.size());
        ModuleControllerTest.assertSame((Object)sub1, nodes.get(0));
        ModuleControllerTest.assertSame((Object)sub2, nodes.get(1));
        ModuleControllerTest.assertSame((Object)sub3, nodes.get(2));
        sub1.setEnabled(false);
        sub2.setVisible(false);
        nodes = controller.getVisibleChildren((INavigationNode)node);
        ModuleControllerTest.assertEquals((int)2, (int)nodes.size());
        ModuleControllerTest.assertSame((Object)sub1, nodes.get(0));
        ModuleControllerTest.assertSame((Object)sub3, nodes.get(1));
    }

    public void testHasSingleLeafChild() {
        ModuleNode node = new ModuleNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubModuleNode sub1 = new SubModuleNode();
        node.addChild((INavigationNode)sub1);
        SubModuleNode sub2 = new SubModuleNode();
        node.addChild((INavigationNode)sub2);
        SubModuleNode sub3 = new SubModuleNode();
        sub2.addChild((INavigationNode)sub3);
        ModuleController controller = new ModuleController((IModuleNode)node);
        ModuleControllerTest.assertFalse((boolean)controller.hasSingleLeafChild());
        sub1.setVisible(false);
        ModuleControllerTest.assertFalse((boolean)controller.hasSingleLeafChild());
        sub1.setVisible(true);
        sub2.setVisible(false);
        ModuleControllerTest.assertTrue((boolean)controller.hasSingleLeafChild());
        sub2.setVisible(true);
        ModuleControllerTest.assertFalse((boolean)controller.hasSingleLeafChild());
        node.removeChild((INavigationNode)sub2);
        ModuleControllerTest.assertTrue((boolean)controller.hasSingleLeafChild());
    }
}

