/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.swt.widgets.Display;

@NonUITestCase
public class SubApplicationControllerTest
extends TestCase {
    private SubApplicationController controller;
    private SubApplicationNode node;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        SubApplicationControllerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.node = new SubApplicationNode();
        this.controller = new SubApplicationController((ISubApplicationNode)this.node);
    }

    protected void tearDown() throws Exception {
        this.controller = null;
        this.node = null;
    }

    public void testGetMenuActionRidget() {
        this.controller.addRidget("menuAction.id1", (IRidget)new LabelRidget());
        ActionRidget menuAction = new ActionRidget();
        this.controller.addRidget("id2", (IRidget)menuAction);
        this.controller.addRidget("menuAction.id3", (IRidget)menuAction);
        this.controller.addRidget("toolbarAction.id4", (IRidget)menuAction);
        SubApplicationControllerTest.assertNull((Object)this.controller.getMenuActionRidget("id1"));
        SubApplicationControllerTest.assertNull((Object)this.controller.getMenuActionRidget("id2"));
        SubApplicationControllerTest.assertSame((Object)menuAction, (Object)this.controller.getMenuActionRidget("id3"));
        SubApplicationControllerTest.assertNull((Object)this.controller.getMenuActionRidget("id4"));
    }

    public void testGetToolbarActionRidget() {
        this.controller.addRidget("toolbarAction.id1", (IRidget)new LabelRidget());
        ActionRidget menuAction = new ActionRidget();
        this.controller.addRidget("id2", (IRidget)menuAction);
        this.controller.addRidget("toolbarAction.id3", (IRidget)menuAction);
        this.controller.addRidget("menuAction.id4", (IRidget)menuAction);
        SubApplicationControllerTest.assertNull((Object)this.controller.getToolbarActionRidget("id1"));
        SubApplicationControllerTest.assertNull((Object)this.controller.getToolbarActionRidget("id2"));
        SubApplicationControllerTest.assertSame((Object)menuAction, (Object)this.controller.getToolbarActionRidget("id3"));
        SubApplicationControllerTest.assertNull((Object)this.controller.getToolbarActionRidget("id4"));
    }
}

