/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.context;

import junit.framework.TestCase;
import org.eclipse.riena.objecttransaction.context.BasicContextCarrier;
import org.eclipse.riena.objecttransaction.context.ContextProxy;
import org.eclipse.riena.objecttransaction.context.IContext;
import org.eclipse.riena.objecttransaction.context.IContextCarrier;
import org.eclipse.riena.objecttransaction.context.IContextProvider;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class ContextProxyTest
extends TestCase {
    private IContext activatedContext;
    private IContext passivatedContext;

    public void testContextManagementOnNotContextCarrier() {
        BasicContextCarrier contextCarrier = new BasicContextCarrier(null);
        ContextProxyTestContext context1 = new ContextProxyTestContext();
        ContextProxyTestContext context2 = new ContextProxyTestContext();
        ContextProxyTest.assertFalse((boolean)context1.equals(context2));
        ContextProxyTestNonContextCarrier nonContextCarrier = new ContextProxyTestNonContextCarrier();
        IContextProxyTestInterface nonContextCarrierProxy = (IContextProxyTestInterface)ContextProxy.cover((Object)nonContextCarrier, (IContextProvider)contextCarrier);
        this.activatedContext = null;
        this.passivatedContext = null;
        ContextProxyTest.assertNull((Object)contextCarrier.getContext());
        contextCarrier.setContext((IContext)context1);
        ContextProxyTest.assertNull((Object)this.activatedContext);
        ContextProxyTest.assertNull((Object)this.passivatedContext);
        nonContextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context1, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context1, (Object)this.passivatedContext);
        this.activatedContext = null;
        this.passivatedContext = null;
        contextCarrier.setContext((IContext)context2);
        ContextProxyTest.assertEquals((Object)context2, (Object)contextCarrier.getContext());
        ContextProxyTest.assertNull((Object)this.activatedContext);
        ContextProxyTest.assertNull((Object)this.passivatedContext);
        nonContextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context2, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context2, (Object)this.passivatedContext);
        this.activatedContext = null;
        this.passivatedContext = null;
        contextCarrier.setContext((IContext)context1);
        nonContextCarrierProxy = (IContextProxyTestInterface)ContextProxy.cover((Object)nonContextCarrier, (IContextProvider)contextCarrier);
        ContextProxyTest.assertEquals((Object)context1, (Object)contextCarrier.getContext());
        ContextProxyTest.assertNull((Object)this.activatedContext);
        ContextProxyTest.assertNull((Object)this.passivatedContext);
        nonContextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context1, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context1, (Object)this.passivatedContext);
    }

    public void testContextManagementOnContextCarrier() {
        ContextProxyTestContext context1 = new ContextProxyTestContext();
        ContextProxyTestContext context2 = new ContextProxyTestContext();
        ContextProxyTest.assertFalse((boolean)context1.equals(context2));
        ContextProxyTestContextCarrier contextCarrier = new ContextProxyTestContextCarrier();
        IContextProxyTestInterfaceCarrier contextCarrierProxy = (IContextProxyTestInterfaceCarrier)ContextProxy.cover((IContextProvider)contextCarrier);
        this.activatedContext = null;
        this.passivatedContext = null;
        ContextProxyTest.assertNull((Object)contextCarrierProxy.getContext());
        contextCarrierProxy.setContext(context1);
        ContextProxyTest.assertEquals((Object)context1, (Object)contextCarrierProxy.getContext());
        contextCarrierProxy.setContext(context2);
        ContextProxyTest.assertEquals((Object)context2, (Object)contextCarrierProxy.getContext());
        contextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context2, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context2, (Object)this.passivatedContext);
        contextCarrierProxy.setContext(context1);
        contextCarrierProxy.doSomething();
        ContextProxyTest.assertEquals((Object)context1, (Object)this.activatedContext);
        ContextProxyTest.assertEquals((Object)context1, (Object)this.passivatedContext);
    }

    private class ContextProxyTestContext
    implements IContext {
        private ContextProxyTestContext() {
        }

        public void activate() {
            ContextProxyTest.this.activatedContext = this;
        }

        public boolean isActivated() {
            return this.equals(ContextProxyTest.this.activatedContext);
        }

        public void passivate() {
            ContextProxyTest.this.passivatedContext = this;
        }
    }

    private static class ContextProxyTestContextCarrier
    implements IContextProxyTestInterfaceCarrier {
        private IContext context;

        private ContextProxyTestContextCarrier() {
        }

        public void doSomething() {
        }

        public IContext getContext() {
            return this.context;
        }

        public void setContext(IContext pContext) {
            this.context = pContext;
        }
    }

    private static class ContextProxyTestNonContextCarrier
    implements IContextProxyTestInterface {
        private ContextProxyTestNonContextCarrier() {
        }

        public void doSomething() {
        }
    }

    private static interface IContextProxyTestInterface {
        public void doSomething();
    }

    private static interface IContextProxyTestInterfaceCarrier
    extends IContextCarrier {
        public void doSomething();
    }
}

