/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.list.value;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.objecttransaction.AbstractTransactedObject;
import org.eclipse.riena.objecttransaction.IObjectId;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.InvalidTransactionFailure;
import org.eclipse.riena.objecttransaction.ObjectTransactionManagerAccessor;
import org.eclipse.riena.objecttransaction.list.value.Addresse;
import org.eclipse.riena.objecttransaction.list.value.GenericOID;
import org.eclipse.riena.objecttransaction.list.value.Vertrag;

public class Kunde
extends AbstractTransactedObject
implements ITransactedObject {
    private String vorname;
    private String nachname;
    private String kundennr;
    private Addresse addresse;
    private List<Vertrag> vertraege;

    private Kunde() {
        if (!ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            throw new InvalidTransactionFailure("cannot instantiate Kunde with private method if not in clean state");
        }
        ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().register((ITransactedObject)this);
    }

    public Kunde(String kundennr) {
        super((IObjectId)new GenericOID("kunde", "kundennrpk", kundennr), "1");
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().register((ITransactedObject)this);
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().registerNew((ITransactedObject)this);
        }
        this.setKundennr(kundennr);
        this.vertraege = new ArrayList<Vertrag>();
    }

    public String getKundennr() {
        return (String)ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().getReference((ITransactedObject)this, "kundennr", (Object)this.kundennr);
    }

    public void setKundennr(String kundennr) {
        if (((GenericOID)this.getObjectId()).getProperties().get("primkey") != null) {
            throw new UnsupportedOperationException("cannot change kundennr (once it is set)");
        }
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            this.kundennr = kundennr;
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().setReference((ITransactedObject)this, "kundennr", (Object)kundennr);
        }
    }

    public String getNachname() {
        return (String)ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().getReference((ITransactedObject)this, "nachname", (Object)this.nachname);
    }

    public void setNachname(String nachname) {
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            this.nachname = nachname;
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().setReference((ITransactedObject)this, "nachname", (Object)nachname);
        }
    }

    public String getVorname() {
        return (String)ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().getReference((ITransactedObject)this, "vorname", (Object)this.vorname);
    }

    public void setVorname(String vorname) {
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            this.vorname = vorname;
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().setReference((ITransactedObject)this, "vorname", (Object)vorname);
        }
    }

    public Addresse getAddresse() {
        return (Addresse)ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().getReference((ITransactedObject)this, "addresse", (ITransactedObject)this.addresse);
    }

    public void setAddresse(Addresse addresse) {
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            this.addresse = addresse;
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().setReference((ITransactedObject)this, "addresse", (ITransactedObject)addresse);
        }
    }

    public void addVertrag(Vertrag vertrag) {
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            this.vertraege.add(vertrag);
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().addReference((ITransactedObject)this, "vertrag", (ITransactedObject)vertrag);
        }
    }

    public void removeVertrag(String vertragsNummer) {
        Vertrag tempVertrag = this.getVertrag(vertragsNummer);
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            this.vertraege.remove((Object)this.getVertrag(vertragsNummer));
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().removeReference((ITransactedObject)this, "vertrag", (ITransactedObject)tempVertrag);
        }
    }

    public void removeVertrag(Vertrag vertrag) {
        if (ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().isCleanModus()) {
            this.vertraege.remove((Object)vertrag);
        } else {
            ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().removeReference((ITransactedObject)this, "vertrag", (ITransactedObject)vertrag);
        }
    }

    public Vertrag getVertrag(String vertragsNummer) {
        Vertrag[] tempVertraege = this.listVertrag();
        int i = 0;
        while (i < tempVertraege.length) {
            if (tempVertraege[i].getVertragsNummer().equals(vertragsNummer)) {
                return tempVertraege[i];
            }
            ++i;
        }
        return null;
    }

    public Vertrag[] listVertrag() {
        List vertraegeSet = ObjectTransactionManagerAccessor.fetchObjectTransactionManager().getCurrent().listReference((ITransactedObject)this, "vertrag", this.vertraege);
        if (vertraegeSet.size() == 0) {
            return new Vertrag[0];
        }
        return vertraegeSet.toArray(new Vertrag[vertraegeSet.size()]);
    }
}

