/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.authentication;

import java.net.URL;
import javax.security.auth.login.LoginException;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.security.authentication.callbackhandler.TestLocalCallbackHandler;
import org.eclipse.riena.security.authentication.module.TestLocalLoginModule;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class LoginModuleTest
extends RienaTestCase {
    private static final String JAAS_CONFIG_FILE = "config/sample_jaas.config";

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.startBundles("org\\.eclipse\\.riena.communication.registry", null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSimpleServiceSampleLoginSuccessful() throws Exception {
        TestLocalCallbackHandler.setSuppliedCredentials("testuser", "testpass");
        TestLocalLoginModule.setCredentials("testuser", "testpass");
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"Local", (URL)configUrl);
        secureContext.login();
        LoginModuleTest.assertNotNull((Object)secureContext.getSubject());
        LoginModuleTest.assertNotNull(secureContext.getSubject().getPrincipals());
        LoginModuleTest.assertTrue((secureContext.getSubject().getPrincipals().size() > 0 ? 1 : 0) != 0);
    }

    public void testSimpleServiceSampleLoginInvalidPassword() throws Exception {
        try {
            TestLocalCallbackHandler.setSuppliedCredentials("testuser", "testpass");
            TestLocalLoginModule.setCredentials("testuser", "invalidpass");
            URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
            ILoginContext secureContext = LoginContextFactory.createContext((String)"Local", (URL)configUrl);
            secureContext.login();
            LoginModuleTest.fail((String)"login MUST fail since the password is wrong");
        }
        catch (LoginException loginException) {
            this.ok("expecting an exception");
        }
    }
}

