/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.authentication;

import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.factory.RemoteServiceFactory;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.model.ICustomerSearch;
import org.eclipse.riena.security.common.BasicAuthenticationCallHook;
import org.eclipse.riena.security.common.ISubjectHolderService;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.IntegrationTestCase;
import org.osgi.framework.ServiceRegistration;

@IntegrationTestCase
public class BasicAuthenticationITest
extends RienaTestCase {
    private IRemoteServiceRegistration customerSearchRegistration;
    private static final String TESTURL = "http://localhost:8080/junit/protected";

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.equinox\\.cm.*", null);
        this.startBundles("org\\.eclipse\\.equinox\\.log.*", null);
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.customerSearchRegistration = new RemoteServiceFactory().createAndRegisterProxy(ICustomerSearch.class, TESTURL, "hessian", Activator.getDefault().getContext());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.customerSearchRegistration.unregister();
    }

    public void testNoCallHook() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            customerSearch.findCustomer(null);
            BasicAuthenticationITest.fail((String)"RemoteFailure HTTP=401 expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("401"));
        }
    }

    public void testWithCallHookNoAuthorization() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
            customerSearch.findCustomer(null);
            serviceReg.unregister();
            BasicAuthenticationITest.fail((String)"RemoteFailure HTTP=401 expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("401"));
        }
    }

    public void testWithCallHookWithInvalidAuthorization() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
            ISubjectHolderService subjectHolderService = (ISubjectHolderService)this.getContext().getService(this.getContext().getServiceReference(ISubjectHolderService.class.getName()));
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new SimplePrincipal("christian"));
            subject.getPrivateCredentials().add("password");
            subjectHolderService.fetchSubjectHolder().setSubject(subject);
            customerSearch.findCustomer(null);
            serviceReg.unregister();
            BasicAuthenticationITest.fail((String)"RemoteFailure HTTP=401 expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("401"));
        }
    }

    public void testWithCallHookWithValidAuthorization() {
        try {
            ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
            ISubjectHolderService subjectHolderService = (ISubjectHolderService)this.getContext().getService(this.getContext().getServiceReference(ISubjectHolderService.class.getName()));
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new SimplePrincipal("scp"));
            subject.getPrivateCredentials().add("scptestpassword");
            subjectHolderService.fetchSubjectHolder().setSubject(subject);
            customerSearch.findCustomer(null);
            serviceReg.unregister();
            BasicAuthenticationITest.fail((String)"RemoteFailure with Protocol Error expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertFalse((boolean)e.getCause().getCause().getMessage().contains("401"));
            BasicAuthenticationITest.assertTrue((String)e.getCause().getCause().getMessage(), (boolean)e.getCause().getCause().getMessage().contains("unknown code"));
        }
    }

    public void testWithCallHookWithMultipleValidAuthorization() {
        ICustomerSearch customerSearch = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
        ServiceRegistration serviceReg = this.getContext().registerService(ICallHook.class.getName(), (Object)new BasicAuthenticationCallHook(), null);
        ISubjectHolderService subjectHolderService = (ISubjectHolderService)this.getContext().getService(this.getContext().getServiceReference(ISubjectHolderService.class.getName()));
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal("scp"));
        subject.getPrivateCredentials().add("scptestpassword");
        subjectHolderService.fetchSubjectHolder().setSubject(subject);
        try {
            customerSearch.findCustomer(null);
            BasicAuthenticationITest.fail((String)"RemoteFailure with Protocol Error expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertFalse((boolean)e.getCause().getCause().getMessage().contains("401"));
            BasicAuthenticationITest.assertTrue((String)e.getCause().getCause().getMessage(), (boolean)e.getCause().getCause().getMessage().contains("unknown code"));
        }
        try {
            customerSearch.findCustomer(null);
            BasicAuthenticationITest.fail((String)"RemoteFailure with Protocol Error expected");
        }
        catch (RemoteFailure e) {
            BasicAuthenticationITest.assertFalse((boolean)e.getCause().getCause().getMessage().contains("401"));
            BasicAuthenticationITest.assertTrue((String)e.getCause().getCause().getMessage(), (boolean)e.getCause().getCause().getMessage().contains("unknown code"));
        }
        serviceReg.unregister();
    }
}

