/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.authorization;

import java.net.URL;
import java.security.AccessControlException;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.factory.RemoteServiceFactory;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.model.Customer;
import org.eclipse.riena.sample.app.common.model.ICustomerSearch;
import org.eclipse.riena.security.authentication.callbackhandler.TestLocalCallbackHandler;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.security.common.authorization.IAuthorizationService;
import org.eclipse.riena.security.common.session.ISessionHolderService;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.IntegrationTestCase;
import org.osgi.framework.ServiceReference;

@IntegrationTestCase
public class AuthorizationServiceITest
extends RienaTestCase {
    private IRemoteServiceRegistration authenticationService;
    private IRemoteServiceRegistration authorizationService;
    private IRemoteServiceRegistration customerService;
    private static final String JAAS_CONFIG_FILE = "config/sample_jaas.config";

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.startBundles("org\\.eclipse\\.riena.communication.registry", null);
        this.authenticationService = new RemoteServiceFactory().createAndRegisterProxy(IAuthenticationService.class, "http://localhost:8080/hessian/AuthenticationService", "hessian", Activator.getDefault().getContext());
        this.authorizationService = new RemoteServiceFactory().createAndRegisterProxy(IAuthorizationService.class, "http://localhost:8080/hessian/AuthorizationService", "hessian", Activator.getDefault().getContext());
        this.customerService = new RemoteServiceFactory().createAndRegisterProxy(ICustomerSearch.class, "http://localhost:8080/hessian/CustomerSearchWS", "hessian", Activator.getDefault().getContext());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationService.unregister();
        this.authorizationService.unregister();
        this.customerService.unregister();
    }

    public void testLoginWithUserWithRights() throws Exception {
        TestLocalCallbackHandler.setSuppliedCredentials("testuser", "testpass");
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"Remote", (URL)configUrl);
        secureContext.login();
        ServiceReference ref = this.getContext().getServiceReference(IAuthenticationService.class.getName());
        IAuthenticationService as = (IAuthenticationService)this.getContext().getService(ref);
        System.out.println("subject:" + secureContext.getSubject());
        System.out.println("login in sucessful");
        ISessionHolderService cfr_ignored_0 = (ISessionHolderService)this.getContext().getService(this.getContext().getServiceReference(ISessionHolderService.class.getName()));
        ICustomerSearch cs = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
        Customer cust = new Customer();
        cust.setLastName("Solo");
        cust.setFirstName("Han");
        cust.setCustomerNumber(Integer.valueOf(1));
        Customer[] foundCustomers = cs.findCustomerWithPermission(cust);
        AuthorizationServiceITest.assertTrue((foundCustomers != null ? 1 : 0) != 0);
        AuthorizationServiceITest.assertTrue((foundCustomers.length > 0 ? 1 : 0) != 0);
        AuthorizationServiceITest.assertTrue((boolean)foundCustomers[0].getLastName().equals("Solo"));
        as.logout();
        System.out.println("logoff sucessful");
    }

    public void testLoginWithUserWithoutRights() throws Exception {
        TestLocalCallbackHandler.setSuppliedCredentials("testuser1", "testpass2");
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"Remote", (URL)configUrl);
        secureContext.login();
        ServiceReference ref = this.getContext().getServiceReference(IAuthenticationService.class.getName());
        IAuthenticationService as = (IAuthenticationService)this.getContext().getService(ref);
        System.out.println("subject:" + secureContext.getSubject());
        System.out.println("login in sucessful");
        ISessionHolderService cfr_ignored_0 = (ISessionHolderService)this.getContext().getService(this.getContext().getServiceReference(ISessionHolderService.class.getName()));
        try {
            ICustomerSearch cs = (ICustomerSearch)this.getContext().getService(this.getContext().getServiceReference(ICustomerSearch.class.getName()));
            Customer cust = new Customer();
            cust.setLastName("Solo");
            cust.setFirstName("Han");
            cust.setCustomerNumber(Integer.valueOf(1));
            cs.findCustomerWithPermission(cust);
            AuthorizationServiceITest.fail((String)"findCustomerWithPermission must not work for testuser1 since it has to authorization");
        }
        catch (AccessControlException accessControlException) {
            this.ok("expected exception");
        }
        as.logout();
        System.out.println("logoff sucessful");
    }
}

