/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.tests;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class UITestHelper {
    public static final int KC_ARROW_DOWN = 0x1000002;
    public static final int KC_ARROW_UP = 0x1000001;
    public static final int KC_HOME = 0x1000007;
    public static final int KC_END = 0x1000008;
    public static final int KC_DEL = 127;

    private UITestHelper() {
    }

    public static void readAndDispatch(Widget control) {
        Display display = control.getDisplay();
        while (!display.readAndDispatch()) {
        }
    }

    public static void sendKeyAction(Display display, int keyCode) {
        EventSender sender = new EventSender(display, keyCode);
        Thread thread = new Thread(sender);
        thread.start();
        UITestHelper.waitAndDispatch(display, thread);
    }

    public static void sendString(Display display, String message) {
        EventSender sender = new EventSender(display, message);
        Thread thread = new Thread(sender);
        thread.start();
        UITestHelper.waitAndDispatch(display, thread);
    }

    private static void waitAndDispatch(Display display, Thread thread) {
        Shell shell = display.getActiveShell();
        while (!shell.isDisposed() && thread.isAlive()) {
            display.readAndDispatch();
        }
    }

    private static class EventSender
    implements Runnable {
        private static final int MS_SHORT_WAIT = 10;
        private static final int MS_LONG_WAIT = 250;
        private final Display display;
        private final int keyCode;
        private final String message;

        EventSender(Display display, int keyCode) {
            this.display = display;
            this.keyCode = keyCode;
            this.message = null;
        }

        EventSender(Display display, String message) {
            this.display = display;
            this.keyCode = 0;
            this.message = message;
        }

        public void run() {
            if (this.message != null) {
                this.sendMessage();
            } else {
                this.sendKeyEvent();
            }
        }

        private void sendMessage() {
            int i = 0;
            while (i < this.message.length()) {
                char ch = this.message.charAt(i);
                boolean isShift = Character.isUpperCase(ch);
                if (isShift) {
                    this.postShift(true);
                }
                this.postCharacter(ch);
                if (isShift) {
                    this.postShift(false);
                }
                ++i;
            }
        }

        private void sendKeyEvent() {
            Event event = new Event();
            event.type = 1;
            event.keyCode = this.keyCode;
            this.doSleep(250);
            this.display.post(event);
            this.doSleep(250);
            event.type = 2;
            this.display.post(event);
            this.doSleep(250);
        }

        private void postCharacter(char ch) {
            Event event = new Event();
            event.type = 1;
            event.character = ch;
            this.doSleep(250);
            this.display.post(event);
            this.doSleep(250);
            event.type = 2;
            this.display.post(event);
            this.doSleep(250);
        }

        private void postShift(boolean keyDown) {
            Event event = new Event();
            event.keyCode = 131072;
            event.type = keyDown ? 1 : 2;
            this.display.post(event);
            this.doSleep(10);
        }

        private void doSleep(int millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

