/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.tests.collect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.tests.collect.NonGatherableTestCase;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestCollector {
    private static final String PLUS = " + ";
    private static int skipChars = -1;

    private TestCollector() {
    }

    public static TestSuite createTestSuiteWith(Bundle bundle, Package withinPackage, Class<? extends Annotation> ... annotationClasses) {
        return TestCollector.createTestSuiteWith(bundle, withinPackage, false, annotationClasses);
    }

    public static TestSuite createTestSuiteWith(Bundle bundle, Package withinPackage, boolean subPackages, Class<? extends Annotation> ... annotationClasses) {
        StringBuilder bob = new StringBuilder("Tests within bundle '").append(bundle.getSymbolicName()).append("' and package '");
        bob.append(withinPackage == null ? "all" : withinPackage.getName()).append("'").append(" recursive '").append(subPackages).append("'");
        bob.append(" and restricted to '");
        Class<? extends Annotation>[] classArray = annotationClasses;
        int n = annotationClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> annotationClass = classArray[n2];
            bob.append(annotationClass.getSimpleName()).append(PLUS);
            ++n2;
        }
        if (annotationClasses.length > 0) {
            bob.setLength(bob.length() - PLUS.length());
        } else {
            bob.append("none");
        }
        bob.append("'.");
        TestSuite suite = new TestSuite(bob.toString());
        for (Class<? extends TestCase> clazz : TestCollector.collectWith(bundle, withinPackage, subPackages, annotationClasses)) {
            suite.addTestSuite(clazz);
        }
        return suite;
    }

    public static List<Class<? extends TestCase>> collectWith(Bundle bundle, Package withinPackage, boolean subPackages, Class<? extends Annotation> ... annotationClasses) {
        ArrayList<Class<? extends TestCase>> testClasses = new ArrayList<Class<? extends TestCase>>();
        for (Class<? extends TestCase> testClass : TestCollector.collect(bundle, withinPackage, subPackages)) {
            boolean collect = annotationClasses.length == 0;
            Class<? extends Annotation>[] classArray = annotationClasses;
            int n = annotationClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Annotation> annotationClass = classArray[n2];
                collect = collect || testClass.isAnnotationPresent(annotationClass);
                ++n2;
            }
            if (!collect) continue;
            testClasses.add(testClass);
        }
        return testClasses;
    }

    public static List<Class<? extends TestCase>> collectUnmarked(Bundle bundle, Package withinPackage) {
        ArrayList<Class<? extends TestCase>> testClasses = new ArrayList<Class<? extends TestCase>>();
        for (Class<? extends TestCase> testClass : TestCollector.collect(bundle, withinPackage, true)) {
            if (testClass.getAnnotations().length != 0) continue;
            testClasses.add(testClass);
        }
        return testClasses;
    }

    public static List<Class<? extends TestCase>> collectBadlyNamed(Bundle bundle, Package withinPackage) {
        ArrayList<Class<? extends TestCase>> testClasses = new ArrayList<Class<? extends TestCase>>();
        for (Class<? extends TestCase> testClass : TestCollector.collect(bundle, withinPackage, true)) {
            if (testClass.getName().endsWith("Test")) continue;
            testClasses.add(testClass);
        }
        return testClasses;
    }

    public static List<Class<? extends TestCase>> collect(Bundle bundle, Package withinPackage, boolean subPackages) {
        ArrayList<Class<? extends TestCase>> testClasses = new ArrayList<Class<? extends TestCase>>();
        Enumeration allClasses = bundle.findEntries("", "*.class", true);
        for (URL entryURL : Iter.able((Enumeration)allClasses)) {
            String url = entryURL.toExternalForm();
            if (url.contains("$")) continue;
            String className = TestCollector.getClassName(bundle, entryURL);
            if (className == null) {
                TestCollector.trace("Could not get class name from ", url);
                continue;
            }
            Class clazz = null;
            try {
                clazz = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                System.out.println(e);
                continue;
            }
            if (withinPackage != null && (!subPackages ? !className.equals(String.valueOf(withinPackage.getName()) + "." + clazz.getSimpleName()) : !className.startsWith(withinPackage.getName()) || !className.endsWith(clazz.getSimpleName()))) continue;
            if (!TestCase.class.isAssignableFrom(clazz) || clazz.isAnnotationPresent(NonGatherableTestCase.class) || Modifier.isAbstract(clazz.getModifiers())) continue;
            testClasses.add(clazz);
        }
        return testClasses;
    }

    private static String getClassName(Bundle bundle, URL entryURL) {
        String name;
        String entry = entryURL.toExternalForm();
        entry = entry.replace(".class", "").replace('/', '.');
        if (skipChars == -1) {
            name = entry;
            int dot = 0;
            while ((dot = name.indexOf(46, dot)) != -1) {
                String className = name.substring(dot + 1);
                try {
                    bundle.loadClass(className);
                    skipChars = entry.indexOf(className);
                    return className;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ++dot;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    ++dot;
                }
            }
        }
        name = entry.substring(skipChars);
        return name;
    }

    private static void trace(Object ... objects) {
        StringBuilder bob = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            bob.append(object);
            ++n2;
        }
        System.err.println(bob.toString());
    }
}

