/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.filter.impl;

import junit.framework.TestCase;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.filter.IUIFilterRuleMarkerNavigation;
import org.eclipse.riena.ui.filter.IUIFilterRuleMarkerRidget;
import org.eclipse.riena.ui.filter.extension.IRuleMapperExtension;
import org.eclipse.riena.ui.filter.extension.IRuleMarkerNavigationMapper;
import org.eclipse.riena.ui.filter.extension.IRuleMarkerRidgetMapper;
import org.eclipse.riena.ui.filter.extension.IRuleValidatorRidgetMapper;
import org.eclipse.riena.ui.filter.impl.RulesProvider;

@NonUITestCase
public class RulesProviderTest
extends TestCase {
    private RulesProvider provider;

    protected void setUp() throws Exception {
        this.provider = new RulesProvider(false);
    }

    protected void tearDown() throws Exception {
        this.provider = null;
    }

    public void testGetRuleMarkerRidget() {
        IRuleMapperExtension[] mappers = new IRuleMapperExtension[]{new Mapper()};
        this.provider.update(mappers);
        IUIFilterRuleMarkerRidget rule = this.provider.getRuleMarkerRidget("disabled");
        RulesProviderTest.assertEquals((Object)new DisabledMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerRidget("hidden");
        RulesProviderTest.assertEquals((Object)new HiddenMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerRidget("mandatory");
        RulesProviderTest.assertEquals((Object)new MandatoryMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerRidget("output");
        RulesProviderTest.assertEquals((Object)new OutputMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerRidget("dummy");
        RulesProviderTest.assertNull((Object)rule);
    }

    public void testGetRuleMarkerNavigation() {
        IRuleMapperExtension[] mappers = new IRuleMapperExtension[]{new Mapper()};
        this.provider.update(mappers);
        IUIFilterRuleMarkerNavigation rule = this.provider.getRuleMarkerNavigation("disabled");
        RulesProviderTest.assertEquals((Object)new DisabledMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerNavigation("hidden");
        RulesProviderTest.assertEquals((Object)new HiddenMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerNavigation("mandatory");
        RulesProviderTest.assertNull((Object)rule);
        rule = this.provider.getRuleMarkerNavigation("output");
        RulesProviderTest.assertNull((Object)rule);
        rule = this.provider.getRuleMarkerNavigation("dummy");
        RulesProviderTest.assertNull((Object)rule);
    }

    public void testGetRuleMarkerMenuItem() {
        IRuleMapperExtension[] mappers = new IRuleMapperExtension[]{new Mapper()};
        this.provider.update(mappers);
        IUIFilterRuleMarkerRidget rule = this.provider.getRuleMarkerMenuItem("disabled");
        RulesProviderTest.assertEquals((Object)new DisabledMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerMenuItem("hidden");
        RulesProviderTest.assertEquals((Object)new HiddenMarker(), (Object)rule.getMarker());
        rule = this.provider.getRuleMarkerMenuItem("mandatory");
        RulesProviderTest.assertNull((Object)rule);
        rule = this.provider.getRuleMarkerMenuItem("output");
        RulesProviderTest.assertNull((Object)rule);
        rule = this.provider.getRuleMarkerMenuItem("dummy");
        RulesProviderTest.assertNull((Object)rule);
    }

    private abstract class AbstractRuleMarkerNavigation
    implements IUIFilterRuleMarkerNavigation {
        private AbstractRuleMarkerNavigation() {
        }

        public void setNode(String nodeId) {
        }

        public void apply(Object object) {
        }

        public boolean matches(Object ... object) {
            return false;
        }

        public void remove(Object object) {
        }
    }

    private abstract class AbstractRuleMarkerRidget
    implements IUIFilterRuleMarkerRidget {
        private AbstractRuleMarkerRidget() {
        }

        public void setId(String id) {
        }

        public void apply(Object object) {
        }

        public boolean matches(Object ... object) {
            return false;
        }

        public void remove(Object object) {
        }
    }

    private class Mapper
    implements IRuleMapperExtension {
        private Mapper() {
        }

        public IRuleMarkerNavigationMapper getNavigationDisabledMarker() {
            return new IRuleMarkerNavigationMapper(){

                public IUIFilterRuleMarkerNavigation getRuleClass() {
                    return new AbstractRuleMarkerNavigation(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new DisabledMarker();
                        }
                    };
                }
            };
        }

        public IRuleMarkerNavigationMapper getNavigationHiddenMarker() {
            return new IRuleMarkerNavigationMapper(){

                public IUIFilterRuleMarkerNavigation getRuleClass() {
                    return new AbstractRuleMarkerNavigation(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new HiddenMarker();
                        }
                    };
                }
            };
        }

        public IRuleMarkerRidgetMapper getRidgetDisabledMarker() {
            return new IRuleMarkerRidgetMapper(){

                public IUIFilterRuleMarkerRidget getRuleClass() {
                    return new AbstractRuleMarkerRidget(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new DisabledMarker();
                        }
                    };
                }
            };
        }

        public IRuleMarkerRidgetMapper getRidgetHiddenMarker() {
            return new IRuleMarkerRidgetMapper(){

                public IUIFilterRuleMarkerRidget getRuleClass() {
                    return new AbstractRuleMarkerRidget(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new HiddenMarker();
                        }
                    };
                }
            };
        }

        public IRuleMarkerRidgetMapper getRidgetMandatoryMarker() {
            return new IRuleMarkerRidgetMapper(){

                public IUIFilterRuleMarkerRidget getRuleClass() {
                    return new AbstractRuleMarkerRidget(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new MandatoryMarker();
                        }
                    };
                }
            };
        }

        public IRuleMarkerRidgetMapper getRidgetOutputMarker() {
            return new IRuleMarkerRidgetMapper(){

                public IUIFilterRuleMarkerRidget getRuleClass() {
                    return new AbstractRuleMarkerRidget(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new OutputMarker();
                        }
                    };
                }
            };
        }

        public IRuleMarkerRidgetMapper getMenuItemDisabledMarker() {
            return new IRuleMarkerRidgetMapper(){

                public IUIFilterRuleMarkerRidget getRuleClass() {
                    return new AbstractRuleMarkerRidget(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new DisabledMarker();
                        }
                    };
                }
            };
        }

        public IRuleMarkerRidgetMapper getMenuItemHiddenMarker() {
            return new IRuleMarkerRidgetMapper(){

                public IUIFilterRuleMarkerRidget getRuleClass() {
                    return new AbstractRuleMarkerRidget(RulesProviderTest.this){

                        public IMarker getMarker() {
                            return new HiddenMarker();
                        }
                    };
                }
            };
        }

        public IRuleValidatorRidgetMapper getRidgetValidator() {
            return null;
        }
    }
}

