/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation.tests;

import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class MinLengthTest
extends RienaTestCase {
    public void testLength() throws Exception {
        MinLength rule = new MinLength(10);
        try {
            rule.validate(new Object());
            MinLengthTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("ValidationFailure expected");
        }
        MinLengthTest.assertTrue((boolean)rule.validate((Object)"0123456789ab").isOK());
        MinLengthTest.assertTrue((boolean)rule.validate((Object)"0123456789a").isOK());
        MinLengthTest.assertTrue((boolean)rule.validate((Object)"01 3 56 89a").isOK());
        MinLengthTest.assertTrue((boolean)rule.validate((Object)"0123456789").isOK());
        MinLengthTest.assertFalse((boolean)rule.validate((Object)"012345678").isOK());
        MinLengthTest.assertFalse((boolean)rule.validate((Object)"abcde").isOK());
        MinLengthTest.assertFalse((boolean)rule.validate(null).isOK());
        MinLength zeroLengthRule = new MinLength(0);
        MinLengthTest.assertTrue((boolean)zeroLengthRule.validate((Object)"abc").isOK());
        MinLengthTest.assertTrue((boolean)zeroLengthRule.validate((Object)"a").isOK());
        MinLengthTest.assertTrue((boolean)zeroLengthRule.validate((Object)" ").isOK());
        MinLengthTest.assertTrue((boolean)zeroLengthRule.validate((Object)"").isOK());
        MinLengthTest.assertTrue((boolean)zeroLengthRule.validate(null).isOK());
    }

    public void testSetInitializationData() throws Exception {
        MinLength rule = new MinLength();
        MinLengthTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        rule = new MinLength();
        rule.setInitializationData(null, null, (Object)"5");
        MinLengthTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        MinLengthTest.assertTrue((boolean)rule.validate((Object)"12345").isOK());
        rule = new MinLength();
        rule.setInitializationData(null, null, (Object)"6,7");
        MinLengthTest.assertFalse((boolean)rule.validate((Object)"12345").isOK());
        MinLengthTest.assertTrue((boolean)rule.validate((Object)"123456").isOK());
    }
}

