/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation.tests;

import junit.framework.TestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.RequiredField;

@NonUITestCase
public class RequiredFieldTest
extends TestCase {
    public void testDefault() throws Exception {
        RequiredField rule = new RequiredField();
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"a").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"ab").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)" ab ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"a b ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"ab ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"$").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"{ }").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate(null).isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"  ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"\n").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"\t").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" \n").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"\n ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" \n ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" \n\t ").isOK());
    }

    public void testIgnoreCharacters() {
        RequiredField rule = new RequiredField();
        rule.setIgnoreCharacters("de1z%ec");
        RequiredFieldTest.assertEquals((String)"setter and getter consistent", (String)"de1z%ec", (String)rule.getIgnoreCharacters());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"a").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"ab").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)" ab ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"a b ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"ab ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"$").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"{ }").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)" { } ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)" {de1z%ec} ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)" de1z%eca").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"de1z%eca ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"d e 1 z % e c a ").isOK());
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"a d e 1 z % e c ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate(null).isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"  ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"\n").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"\t").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" \n").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"\n ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" \n ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" \n\t ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"de1z%ec").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" de1z%ec ").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)" de1z%ec\n").isOK());
        RequiredFieldTest.assertFalse((boolean)rule.validate((Object)"\tde1z%ec ").isOK());
        int t = 0;
        while (t < "de1z%ec".length() - 1) {
            char ignored = "de1z%ec".charAt(t);
            RequiredFieldTest.assertFalse((String)("ignored char: '" + ignored + "'"), (boolean)rule.validate((Object)(String.valueOf(ignored) + "\t\n")).isOK());
            RequiredFieldTest.assertFalse((String)("ignored char: '" + ignored + "'"), (boolean)rule.validate((Object)(String.valueOf(ignored) + "\t\n" + ignored)).isOK());
            RequiredFieldTest.assertFalse((String)("ignored char: '" + ignored + "'"), (boolean)rule.validate((Object)("\t\n" + ignored)).isOK());
            RequiredFieldTest.assertFalse((String)("ignored char: '" + ignored + "'"), (boolean)rule.validate((Object)("\t " + ignored + " \n")).isOK());
            ++t;
        }
    }

    public void testNoNullPointerException() {
        RequiredField rule = new RequiredField();
        rule.setIgnoreCharacters(null);
        RequiredFieldTest.assertTrue((boolean)rule.validate((Object)"a").isOK());
    }
}

