/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation.tests;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.riena.tests.TestUtils;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidRange;

@NonUITestCase
public class ValidRangeTest
extends TestCase {
    public void testRangeUSlocale() throws Exception {
        ValidRange rule = new ValidRange((Number)0, (Number)10, Locale.US);
        ValidRangeTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2.5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-0.0000001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10.0000001").isOK());
        rule = new ValidRange((Number)-5000, (Number)5000, Locale.US);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5,000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"- 5,000").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5000.0001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5,000.0001").isOK());
        rule = new ValidRange((Number)10, (Number)20, Locale.US);
        ValidRangeTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"").isOK());
    }

    public void testRangeGermanLocale() throws Exception {
        ValidRange rule = new ValidRange((Number)0, (Number)10, Locale.GERMANY);
        ValidRangeTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2,5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-0,0000001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10,0000001").isOK());
        rule = new ValidRange((Number)-5000, (Number)5000, Locale.GERMANY);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5.000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"- 5.000").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5000,0001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5.000,0001").isOK());
        rule = new ValidRange((Number)10, (Number)20, Locale.GERMANY);
        ValidRangeTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"").isOK());
    }

    public void testRangeArabLocale() throws Exception {
        if (!TestUtils.isArabLocaleAvailable()) {
            System.err.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".testRangeArabLocale(): Skipping test because no Arab locale is available. Use international JRE to run all tests.");
            return;
        }
        ValidRange rule = new ValidRange((Number)0, (Number)10, new Locale("ar", "AE"));
        ValidRangeTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2.5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"0.0000001-").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10.0000001").isOK());
        rule = new ValidRange((Number)-5000, (Number)5000, new Locale("ar", "AE"));
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5000-").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5,000-").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5,000 -").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"5000.0001-").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"5,000.0001 -").isOK());
        rule = new ValidRange((Number)10, (Number)20, new Locale("ar", "AE"));
        ValidRangeTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"").isOK());
    }

    public void testConstructorInitTypes() throws Exception {
        ValidRange rule = new ValidRange((Number)-10, (Number)10);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange((Number)-10, (Number)10);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange((Number)-10L, (Number)10L);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange((Number)Float.valueOf(-10.0f), (Number)Float.valueOf(10.0f));
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange((Number)-10.0, (Number)10.0);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange((Number)BigInteger.ZERO, (Number)BigInteger.TEN);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange((Number)BigDecimal.ZERO, (Number)BigDecimal.TEN);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
    }

    public void testUnparseableNumbers() throws Exception {
        ValidRange rule = new ValidRange((Number)0, (Number)10, Locale.US);
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"A10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1A0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10A").isOK());
    }

    public void testConstructorSanity() throws Exception {
        try {
            new ValidRange((Number)10, (Number)10);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new ValidRange((Number)10, (Number)1000.0);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new ValidRange((Number)100, (Number)10);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new ValidRange(null, (Number)10);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new ValidRange((Number)100, null);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new ValidRange(null, null);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new ValidRange((Number)10, (Number)100, null);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testSetInitializationData() throws Exception {
        ValidRange rule = new ValidRange();
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange();
        rule.setInitializationData(null, null, (Object)"1");
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10").isOK());
        rule = new ValidRange();
        rule.setInitializationData(null, null, (Object)"1,10");
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"11").isOK());
        rule = new ValidRange();
        rule.setInitializationData(null, null, (Object)"1.1,10.1");
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"11").isOK());
        rule = new ValidRange();
        String localString = String.valueOf(Locale.US.getLanguage()) + "," + Locale.US.getCountry();
        rule.setInitializationData(null, null, (Object)("1.1,10.1," + localString));
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"1.1").isOK());
        rule = new ValidRange();
        localString = String.valueOf(Locale.GERMANY.getLanguage()) + "," + Locale.GERMANY.getCountry();
        rule.setInitializationData(null, null, (Object)("1.1,10.1," + localString));
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"1,1").isOK());
    }
}

