/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.rienadefault;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.swt.lnf.ILnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfTheme;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultTheme;
import org.eclipse.swt.graphics.Color;

@NonUITestCase
public class RienaDefaultLnfTest
extends TestCase {
    private RienaDefaultLnf lnf;

    protected void setUp() throws Exception {
        this.lnf = LnfManager.getLnf();
    }

    protected void tearDown() throws Exception {
        this.lnf.setTheme(null);
        LnfManager.dispose();
        this.lnf = null;
    }

    public void testInitialize() throws Exception {
        this.lnf.uninitialize();
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getRenderer("SubModuleView.borderRenderer"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
        this.lnf.initialize();
        RienaDefaultLnfTest.assertNotNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
    }

    public void testUninitialize() throws Exception {
        Color color = this.lnf.getColor("EmbeddedTitlebar.foreground");
        RienaDefaultLnfTest.assertNotNull((Object)color);
        this.lnf.uninitialize();
        RienaDefaultLnfTest.assertTrue((boolean)color.isDisposed());
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
    }

    public void testGetColor() throws Exception {
        this.lnf.initialize();
        RienaDefaultLnfTest.assertNotNull((Object)this.lnf.getColor("EmbeddedTitlebar.foreground"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("EmbeddedTitlebar.font"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getColor("dummy"));
    }

    public void testGetFont() throws Exception {
        this.lnf.initialize();
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getFont("EmbeddedTitlebar.foreground"));
        RienaDefaultLnfTest.assertNotNull((Object)this.lnf.getFont("EmbeddedTitlebar.font"));
        RienaDefaultLnfTest.assertNull((Object)this.lnf.getFont("dummy"));
    }

    public void testGetTheme() throws Exception {
        RienaDefaultLnfTest.assertEquals(RienaDefaultTheme.class, this.lnf.getTheme().getClass());
        this.lnf.setTheme((ILnfTheme)new DummyTheme());
        RienaDefaultLnfTest.assertEquals(DummyTheme.class, this.lnf.getTheme().getClass());
    }

    public void testSetTheme() throws Exception {
        Color color = this.lnf.getColor("EmbeddedTitlebar.foreground");
        RienaDefaultLnfTest.assertNotNull((Object)color);
        this.lnf.setTheme((ILnfTheme)new DummyTheme());
        this.lnf = LnfManager.getLnf();
        RienaDefaultLnfTest.assertTrue((boolean)color.isDisposed());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyTheme
    implements ILnfTheme {
        private DummyTheme() {
        }

        public void addCustomColors(Map<String, ILnfResource> table) {
        }

        public void addCustomFonts(Map<String, ILnfResource> table) {
        }

        public void addCustomImages(Map<String, ILnfResource> table) {
        }

        public void addCustomSettings(Map<String, Object> table) {
        }
    }
}

