/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.core.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.core.resource.IconState;

public final class IconManager
implements IIconManager {
    private static final String EXTENSION_SEPERATOR = ".";
    private Map<String, Icon> icons = new HashMap<String, Icon>();

    public String getIconID(String name, IconSize size) {
        return this.getIconID(name, size, IconState.NORMAL);
    }

    public String getIconID(String name, IconSize size, IconState state) {
        if (name == null) {
            return null;
        }
        Icon icon = new Icon(name, size, state);
        String iconID = icon.getID();
        this.icons.put(iconID, icon);
        return iconID;
    }

    public String getName(String iconID) {
        Icon icon = this.icons.get(iconID);
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public IconSize getSize(String iconID) {
        Icon icon = this.icons.get(iconID);
        if (icon != null) {
            return icon.getSize();
        }
        return null;
    }

    public IconState getState(String iconID) {
        Icon icon = this.icons.get(iconID);
        if (icon != null) {
            return icon.getState();
        }
        return null;
    }

    public boolean hasExtension(String iconID) {
        return iconID.indexOf(EXTENSION_SEPERATOR) != -1;
    }

    private static class Icon {
        private String name;
        private IconSize size;
        private IconState state;

        public Icon(String name, IconSize size, IconState state) {
            this.name = name;
            this.size = size;
            this.state = state;
        }

        public String getID() {
            return String.valueOf(this.name) + this.state.getDefaultMapping() + this.size.getDefaultMapping();
        }

        public String getName() {
            return this.name;
        }

        public IconSize getSize() {
            return this.size;
        }

        public IconState getState() {
            return this.state;
        }
    }
}

