/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.riena.ui.core.uiprocess.IProcessInfoAware;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizer;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerObserver;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitorContainer;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;

public class ProgressVisualizer
extends PlatformObject
implements IProgressVisualizer {
    private Collection<IProgressVisualizerObserver> observers = new ArrayList<IProgressVisualizerObserver>();
    private ProcessInfo processInfo;
    private int currentProgress = -1;

    public void finalUpdateUI() {
        ArrayList<IProgressVisualizerObserver> currentObservers = new ArrayList<IProgressVisualizerObserver>(this.observers);
        if (currentObservers.size() > 0) {
            for (IProgressVisualizerObserver anObserver : currentObservers) {
                anObserver.finalUpdateUI(this);
                anObserver.removeProgressVisualizer(this);
            }
        }
    }

    public void initialUpdateUI(int totalWork) {
        ArrayList<IProgressVisualizerObserver> currentObservers = new ArrayList<IProgressVisualizerObserver>(this.observers);
        for (IProgressVisualizerObserver anObserver : currentObservers) {
            anObserver.addProgressVisualizer(this);
            anObserver.setActiveProgressVisualizer(this);
            anObserver.initialUpdateUI(this, totalWork);
        }
    }

    public void updateProgress(int progress) {
        this.setCurrentProgress(progress);
        ArrayList<IProgressVisualizerObserver> currentObservers = new ArrayList<IProgressVisualizerObserver>(this.observers);
        for (IProgressVisualizerObserver anObserver : currentObservers) {
            anObserver.updateProgress(this, progress);
        }
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public void activate() {
        ArrayList<IProgressVisualizerObserver> currentObservers = new ArrayList<IProgressVisualizerObserver>(this.observers);
        for (IProgressVisualizerObserver anObserver : currentObservers) {
            anObserver.setActiveProgressVisualizer(this);
        }
    }

    public void addObserver(IProgressVisualizerObserver anObserver) {
        if (anObserver != null) {
            this.observers.add(anObserver);
        }
    }

    public void removeObserver(IProgressVisualizerObserver anObserver) {
        this.observers.remove(anObserver);
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public void setCurrentProgress(int currentProgress) {
        this.currentProgress = currentProgress;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProcessInfoAware.class || adapter == IProgressVisualizer.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean isActive(IUIMonitorContainer container) {
        return container.isVisualizing();
    }
}

