/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.swt.utils.ImageUtil;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSWTWidgetRidget
extends AbstractRidget
implements IMarkableRidget {
    private static Image missingImage;
    private Widget uiControl;
    private String toolTip = null;
    private boolean blocked;
    private ErrorMessageMarker errorMarker;
    private DisabledMarker disabledMarker;
    private MandatoryMarker mandatoryMarker;
    private OutputMarker outputMarker;
    private HiddenMarker hiddenMarker;
    private AbstractMarkerSupport markerSupport;

    public static void assertType(Object uiControl, Class<?> type) {
        if (uiControl != null && !type.isAssignableFrom(uiControl.getClass())) {
            String expectedClassName = type.getSimpleName();
            String controlClassName = uiControl.getClass().getSimpleName();
            throw new BindingException("uiControl of  must be a " + expectedClassName + " but was a " + controlClassName);
        }
    }

    public final void setUIControl(Object uiControl) {
        this.checkUIControl(uiControl);
        this.uninstallListeners();
        this.unbindUIControl();
        this.uiControl = (Widget)uiControl;
        this.updateMarkers();
        this.updateToolTip();
        this.bindUIControl();
        this.installListeners();
    }

    public Widget getUIControl() {
        return this.uiControl;
    }

    public String getID() {
        if (this.getUIControl() != null) {
            SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
            return locator.locateBindingProperty((Object)this.getUIControl());
        }
        return null;
    }

    public void requestFocus() {
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public void setFocusable(boolean focusable) {
    }

    public final boolean isVisible() {
        return this.uiControl != null && this.getMarkersOfType(HiddenMarker.class).isEmpty();
    }

    public final void setVisible(boolean visible) {
        if (this.hiddenMarker == null) {
            this.hiddenMarker = new HiddenMarker();
        }
        if (visible) {
            this.removeMarker((IMarker)this.hiddenMarker);
        } else {
            this.addMarker((IMarker)this.hiddenMarker);
        }
    }

    public final void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTip();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    public final String getToolTipText() {
        return this.toolTip;
    }

    public final boolean isBlocked() {
        return this.blocked;
    }

    public final void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    protected abstract void checkUIControl(Object var1);

    protected abstract void bindUIControl();

    protected abstract void unbindUIControl();

    public abstract boolean isDisableMandatoryMarker();

    protected abstract void updateToolTip();

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected Image getManagedImage(String key) {
        Image image = ImageUtil.getImage((String)key);
        if (image == null) {
            image = this.getMissingImage();
        }
        return image;
    }

    public final synchronized Image getMissingImage() {
        if (missingImage == null) {
            missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return missingImage;
    }

    protected boolean hasChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return !oldValue.equals(newValue);
    }

    public final boolean isErrorMarked() {
        return !this.getMarkersOfType(ErrorMarker.class).isEmpty();
    }

    public final void setErrorMarked(boolean errorMarked) {
        this.setErrorMarked(errorMarked, null);
    }

    protected final void setErrorMarked(boolean errorMarked, String message) {
        if (!errorMarked) {
            if (this.errorMarker != null) {
                this.removeMarker((IMarker)this.errorMarker);
            }
        } else {
            if (this.errorMarker == null) {
                this.errorMarker = new ErrorMessageMarker(message);
            } else {
                this.errorMarker.setMessage(message);
            }
            this.addMarker((IMarker)this.errorMarker);
        }
    }

    public final synchronized void addMarker(IMarker marker) {
        if (this.markerSupport == null) {
            this.markerSupport = this.createMarkerSupport();
        }
        if (marker instanceof MandatoryMarker) {
            ((MandatoryMarker)marker).setDisabled(this.isDisableMandatoryMarker());
        }
        this.markerSupport.addMarker(marker);
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new MarkerSupport(this, this.propertyChangeSupport);
    }

    public final Collection<IMarker> getMarkers() {
        if (this.markerSupport != null) {
            return this.markerSupport.getMarkers();
        }
        return Collections.emptySet();
    }

    public final <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        if (this.markerSupport != null) {
            return this.markerSupport.getMarkersOfType(type);
        }
        return Collections.emptySet();
    }

    public final void removeAllMarkers() {
        if (this.markerSupport != null) {
            this.markerSupport.removeAllMarkers();
        }
    }

    public final void removeMarker(IMarker marker) {
        if (this.markerSupport != null) {
            this.markerSupport.removeMarker(marker);
        }
    }

    public final boolean isEnabled() {
        return this.getMarkersOfType(DisabledMarker.class).isEmpty();
    }

    public final synchronized void setEnabled(boolean enabled) {
        if (enabled) {
            if (this.disabledMarker != null) {
                this.removeMarker((IMarker)this.disabledMarker);
            }
        } else {
            if (this.disabledMarker == null) {
                this.disabledMarker = new DisabledMarker();
            }
            this.addMarker((IMarker)this.disabledMarker);
        }
    }

    public final boolean isOutputOnly() {
        return !this.getMarkersOfType(OutputMarker.class).isEmpty();
    }

    public final void setOutputOnly(boolean outputOnly) {
        if (!outputOnly) {
            if (this.outputMarker != null) {
                this.removeMarker((IMarker)this.outputMarker);
            }
        } else {
            if (this.outputMarker == null) {
                this.outputMarker = new OutputMarker();
            }
            this.addMarker((IMarker)this.outputMarker);
        }
    }

    public final boolean isMandatory() {
        return !this.getMarkersOfType(MandatoryMarker.class).isEmpty();
    }

    public final void setMandatory(boolean mandatory) {
        if (!mandatory) {
            if (this.mandatoryMarker != null) {
                this.removeMarker((IMarker)this.mandatoryMarker);
            }
        } else {
            if (this.mandatoryMarker == null) {
                this.mandatoryMarker = new MandatoryMarker();
            }
            this.addMarker((IMarker)this.mandatoryMarker);
        }
    }

    protected final void disableMandatoryMarkers(boolean disable) {
        for (IMarker iMarker : this.getMarkersOfType(MandatoryMarker.class)) {
            MandatoryMarker mMarker = (MandatoryMarker)iMarker;
            mMarker.setDisabled(disable);
        }
    }

    private void updateMarkers() {
        if (this.markerSupport != null) {
            this.markerSupport.updateMarkers();
        }
    }
}

