/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.math.BigDecimal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;

public class DecimalTextRidget
extends NumericTextRidget
implements IDecimalTextRidget {
    public DecimalTextRidget() {
        this.setMaxLength(10);
        this.setPrecision(2);
        this.setText("0");
        this.setSigned(false);
    }

    protected void checkNumber(String number) {
        if (!"".equals(number)) {
            try {
                new BigDecimal(this.localStringToBigDecimal(number));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Not a valid decimal: " + number);
            }
        }
    }

    protected boolean isNegative(String text) {
        BigDecimal value = new BigDecimal(this.localStringToBigDecimal(text));
        return value.compareTo(BigDecimal.ZERO) < 0;
    }

    protected boolean isNotEmpty(String text) {
        return super.isNotEmpty(text) && !text.equals(String.valueOf(DECIMAL_SEPARATOR));
    }

    public synchronized int getMaxLength() {
        return super.getMaxLength();
    }

    public synchronized int getPrecision() {
        return super.getPrecision();
    }

    public final synchronized void setMaxLength(int maxLength) {
        Assert.isLegal((maxLength > 0 ? 1 : 0) != 0, (String)("maxLength must be greater than zero: " + maxLength));
        int oldValue = this.getMaxLength();
        if (oldValue != maxLength) {
            super.setMaxLength(maxLength);
            this.firePropertyChange("maxLength", oldValue, maxLength);
        }
    }

    public final synchronized void setPrecision(int numberOfFractionDigits) {
        Assert.isLegal((numberOfFractionDigits > -1 ? 1 : 0) != 0, (String)("numberOfFractionDigits must > -1: " + numberOfFractionDigits));
        int oldValue = this.getPrecision();
        if (oldValue != numberOfFractionDigits) {
            super.setPrecision(numberOfFractionDigits);
            this.firePropertyChange("precision", oldValue, numberOfFractionDigits);
        }
    }

    private String localStringToBigDecimal(String number) {
        return DecimalTextRidget.ungroup(number).replace(DECIMAL_SEPARATOR, '.');
    }
}

