/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;

public final class MarkerSupport
extends AbstractMarkerSupport {
    public static final boolean HIDE_DISABLED_RIDGET_CONTENT;
    private Color preOutputBg;
    private Color preMandatoryBg;
    private Color preNegativeFg;
    private ControlDecoration errorDecoration;

    static {
        String value = System.getProperty("HIDE_DISABLED_RIDGET_CONTENT");
        HIDE_DISABLED_RIDGET_CONTENT = value == null ? true : Boolean.parseBoolean(value);
    }

    public MarkerSupport(IMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        super(ridget, propertyChangeSupport);
    }

    public void updateMarkers() {
        this.updateUIControl();
    }

    protected void handleMarkerAttributesChanged() {
        this.updateUIControl();
        super.handleMarkerAttributesChanged();
    }

    private void addError(Control control) {
        if (this.errorDecoration == null) {
            this.errorDecoration = new ControlDecoration(control, 16512);
            this.errorDecoration.setMarginWidth(1);
            this.errorDecoration.setImage(Activator.getSharedImage("IMG_ERROR_DECO"));
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MarkerSupport.this.errorDecoration.dispose();
                }
            });
        }
        this.errorDecoration.show();
    }

    private void addMandatory(Control control) {
        if (this.preMandatoryBg == null) {
            this.preMandatoryBg = control.getBackground();
            Color color = Activator.getSharedColor(control.getDisplay(), "COLOR_MANDATORY");
            control.setBackground(color);
        }
    }

    private void addNegative(Control control) {
        if (this.preNegativeFg == null) {
            this.preNegativeFg = control.getForeground();
            control.setForeground(control.getDisplay().getSystemColor(3));
        }
    }

    private void addOutput(Control control, Color color) {
        if (this.preOutputBg == null) {
            this.preOutputBg = control.getBackground();
            control.setBackground(color);
        }
        if (control instanceof Button) {
            control.setVisible(false);
        }
    }

    private void clearError() {
        if (this.errorDecoration != null) {
            this.errorDecoration.hide();
        }
    }

    private void clearMandatory(Control control) {
        if (this.preMandatoryBg != null) {
            control.setBackground(this.preMandatoryBg);
            this.preMandatoryBg = null;
        }
    }

    private void clearNegative(Control control) {
        if (this.preNegativeFg != null) {
            control.setForeground(this.preNegativeFg);
            this.preNegativeFg = null;
        }
    }

    private void clearOutput(Control control) {
        if (this.preOutputBg != null) {
            control.setBackground(this.preOutputBg);
            this.preOutputBg = null;
        }
        if (control instanceof Button) {
            control.setVisible(this.ridget.isVisible());
        }
    }

    private boolean isMandatory(IMarkableRidget ridget) {
        boolean result = false;
        Iterator iter = ridget.getMarkersOfType(MandatoryMarker.class).iterator();
        while (!result && iter.hasNext()) {
            boolean bl = result = !((MandatoryMarker)iter.next()).isDisabled();
        }
        return result;
    }

    private void updateVisible(Control control) {
        control.setVisible(this.ridget.isVisible());
    }

    private void updateDisabled(Control control) {
        control.setEnabled(this.ridget.isEnabled());
    }

    private void updateError(Control control) {
        if (this.ridget.isErrorMarked() && this.ridget.isEnabled() && this.ridget.isVisible()) {
            if (!(control instanceof Button) || !this.ridget.isOutputOnly()) {
                this.addError(control);
            } else {
                this.clearError();
            }
        } else {
            this.clearError();
        }
    }

    private void updateMandatory(Control control) {
        if (this.isMandatory(this.ridget) && !this.ridget.isOutputOnly() && this.ridget.isEnabled()) {
            this.addMandatory(control);
        } else {
            this.clearMandatory(control);
        }
    }

    private void updateNegative(Control control) {
        if (!this.ridget.getMarkersOfType(NegativeMarker.class).isEmpty() && this.ridget.isEnabled()) {
            this.addNegative(control);
        } else {
            this.clearNegative(control);
        }
    }

    private void updateOutput(Control control) {
        if (this.ridget.isOutputOnly() && this.ridget.isEnabled()) {
            this.clearMandatory(control);
            this.clearOutput(control);
            if (this.isMandatory(this.ridget)) {
                Color color = Activator.getSharedColor(control.getDisplay(), "COLOR_MANDATORY_OUTPUT");
                this.addOutput(control, color);
            } else {
                Color color = Activator.getSharedColor(control.getDisplay(), "COLOR_OUTPUT");
                this.addOutput(control, color);
            }
        } else {
            this.clearOutput(control);
        }
    }

    private void updateUIControl() {
        Control control = (Control)this.ridget.getUIControl();
        if (control != null) {
            this.stopRedraw(control);
            try {
                this.updateVisible(control);
                this.updateDisabled(control);
                this.updateOutput(control);
                this.updateMandatory(control);
                this.updateError(control);
                this.updateNegative(control);
            }
            finally {
                this.startRedraw(control);
            }
        }
    }

    private void startRedraw(Control control) {
        if (!this.skipRedrawForBug258176(control)) {
            control.setRedraw(true);
            control.redraw();
        }
    }

    private void stopRedraw(Control control) {
        if (!this.skipRedrawForBug258176(control)) {
            control.setRedraw(false);
        }
    }

    private boolean skipRedrawForBug258176(Control control) {
        return control instanceof Combo || control instanceof Table || control instanceof List;
    }
}

