/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBoxRidget
extends AbstractRidget
implements IMessageBoxRidget {
    private MessageBox messageBox;
    private String title;
    private String text;
    private boolean blocked;
    private boolean visible;
    private boolean focusable = true;
    private FocusListener focusManager;
    private IMessageBoxRidget.Type type = IMessageBoxRidget.Type.PLAIN;
    private IMessageBoxRidget.MessageBoxOption[] options = OPTIONS_OK;

    public MessageBoxRidget() {
        this.focusManager = new FocusManager();
    }

    public IMessageBoxRidget.MessageBoxOption[] getOptions() {
        return this.options;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public IMessageBoxRidget.Type getType() {
        return this.type;
    }

    public void setOptions(IMessageBoxRidget.MessageBoxOption[] options) {
        this.options = options;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(IMessageBoxRidget.Type type) {
        this.type = type;
    }

    public IMessageBoxRidget.MessageBoxOption show() {
        if (this.messageBox != null) {
            if (this.type == null) {
                this.type = IMessageBoxRidget.Type.PLAIN;
            }
            return this.show(this.type);
        }
        return null;
    }

    private IMessageBoxRidget.MessageBoxOption show(IMessageBoxRidget.Type type) {
        this.messageBox.show(this.getTitle(), this.getText(), this.getType(type), this.getButtonLabels(type));
        return this.getResultOption();
    }

    private String[] getButtonLabels(IMessageBoxRidget.Type type) {
        String[] labels = new String[this.options.length];
        int i = 0;
        while (i < this.options.length) {
            labels[i] = this.getButtonLabel(this.options[i]);
            ++i;
        }
        return labels;
    }

    private String getButtonLabel(IMessageBoxRidget.MessageBoxOption option) {
        if (OK.equals(option)) {
            return IDialogConstants.OK_LABEL;
        }
        if (CANCEL.equals(option)) {
            return IDialogConstants.CANCEL_LABEL;
        }
        if (YES.equals(option)) {
            return IDialogConstants.YES_LABEL;
        }
        if (NO.equals(option)) {
            return IDialogConstants.NO_LABEL;
        }
        return option.getLabel();
    }

    private IMessageBoxRidget.MessageBoxOption getResultOption() {
        int result = this.messageBox.getResult();
        if (result == -1) {
            return CLOSED;
        }
        return this.getOptions()[result];
    }

    private int getType(IMessageBoxRidget.Type type) {
        switch (type) {
            case PLAIN: {
                return 0;
            }
            case INFORMATION: {
                return 2;
            }
            case WARNING: {
                return 4;
            }
            case ERROR: {
                return 1;
            }
            case HELP: {
                return 2;
            }
            case QUESTION: {
                return 3;
            }
        }
        return 0;
    }

    public String getID() {
        if (this.getUIControl() != null) {
            return this.getUIControl().getPropertyName();
        }
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public MessageBox getUIControl() {
        return this.messageBox;
    }

    public boolean hasFocus() {
        return this.messageBox.hasFocus();
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public boolean isVisible() {
        return this.messageBox != null && this.visible;
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            this.messageBox.requestFocus();
        }
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        this.setFocusable(!blocked);
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public void setToolTipText(String toolTipText) {
        throw new UnsupportedOperationException("not supported");
    }

    public void setUIControl(Object uiControl) {
        this.assertUIControlType(uiControl, MessageBox.class);
        this.uninstallListeners();
        this.messageBox = (MessageBox)uiControl;
        this.installListeners();
        this.updateUIControl();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.updateUIControl();
    }

    public void updateFromModel() {
    }

    private void updateUIControl() {
        if (this.messageBox != null) {
            this.updateVisible();
        }
    }

    private void updateVisible() {
        this.messageBox.setVisible(this.visible);
    }

    protected void assertUIControlType(Object uiControl, Class<MessageBox> requiredUIControlType) {
        Assert.isTrue((uiControl == null || requiredUIControlType.isAssignableFrom(uiControl.getClass()) ? 1 : 0) != 0, (String)("Wrong UI-control type. Expected " + requiredUIControlType));
    }

    protected final void installListeners() {
        if (this.getUIControl() != null) {
            this.getUIControl().addFocusListener(this.focusManager);
        }
    }

    protected final void uninstallListeners() {
        if (this.getUIControl() != null) {
            this.getUIControl().removeFocusListener(this.focusManager);
        }
    }

    private final class FocusManager
    extends FocusAdapter {
        private FocusManager() {
        }

        public void focusGained(FocusEvent e) {
            if (MessageBoxRidget.this.focusable) {
                MessageBoxRidget.this.fireFocusGained(new org.eclipse.riena.ui.ridgets.listener.FocusEvent(null, (IRidget)MessageBoxRidget.this));
            } else {
                Control control = (Control)e.widget;
                Composite parent = control.getParent();
                Control[] tabList = parent.getTabList();
                int i = this.findNextElement(control, tabList);
                if (i != -1) {
                    Control nextFocusControl = tabList[i];
                    nextFocusControl.setFocus();
                } else {
                    Composite pParent = parent.getParent();
                    if (pParent != null && (i = this.findNextElement((Control)parent, tabList = pParent.getTabList())) != -1) {
                        Control nextFocusControl = tabList[i];
                        nextFocusControl.setFocus();
                    }
                }
            }
        }

        public void focusLost(FocusEvent e) {
            if (MessageBoxRidget.this.focusable) {
                MessageBoxRidget.this.fireFocusLost(new org.eclipse.riena.ui.ridgets.listener.FocusEvent((IRidget)MessageBoxRidget.this, null));
            }
        }

        private int findNextElement(Control control, Control[] controls) {
            Control candidate;
            int myIndex = -1;
            int i = 0;
            while (myIndex == -1 && i < controls.length) {
                if (controls[i] == control) {
                    myIndex = i;
                }
                ++i;
            }
            int result = -1;
            int i2 = myIndex + 1;
            while (result == -1 && i2 < controls.length) {
                candidate = controls[i2];
                if (candidate.isEnabled() && candidate.isVisible()) {
                    result = i2;
                }
                ++i2;
            }
            i2 = 0;
            while (result == -1 && i2 < myIndex) {
                candidate = controls[i2];
                if (candidate.isEnabled() && candidate.isVisible()) {
                    result = i2;
                }
                ++i2;
            }
            return result;
        }
    }
}

