/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;

public class SegmentedString {
    private final char[] fields;
    private String pattern;

    public static boolean isDigit(char fChar) {
        return Character.isDigit(fChar);
    }

    public static boolean isSeparator(char fChar) {
        return ".:/- ".indexOf(fChar) != -1;
    }

    public SegmentedString(String format) {
        this.pattern = this.createPattern(format);
        this.fields = new char[this.pattern.length()];
        int i = 0;
        while (i < this.pattern.length()) {
            char pChar = this.pattern.charAt(i);
            this.fields[i] = pChar != 'd' ? (int)format.charAt(i) : 32;
            ++i;
        }
    }

    public SegmentedString(String format, String value) {
        this.pattern = this.createPattern(format);
        this.fields = new char[this.pattern.length()];
        int i = 0;
        while (i < value.length()) {
            this.fields[i] = value.charAt(i);
            ++i;
        }
    }

    public int delete(int from, int to) {
        return this.delete(from, to, true);
    }

    public int findNewCursorPosition(int caretPosition, int delta) {
        Assert.isLegal((delta == 1 || delta == -1 ? 1 : 0) != 0);
        int pos = caretPosition;
        if (caretPosition + delta <= this.pattern.length() && caretPosition + delta >= 0) {
            pos = caretPosition + delta;
        }
        while (pos < this.pattern.length() && pos > -1) {
            if (this.pattern.charAt(pos) == '|' || this.pattern.charAt(pos) != 'd' || this.fields[pos] != ' ') break;
            pos += delta;
        }
        return pos;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int insert(int index, String value) {
        int idx = index;
        boolean proceed = true;
        int i = 0;
        while (proceed && i < value.length()) {
            char sChar = value.charAt(i);
            boolean bl = proceed = SegmentedString.isDigit(sChar) || SegmentedString.isSeparator(sChar);
            if (proceed) {
                idx = this.insert(idx, sChar);
            }
            ++i;
        }
        idx += this.shiftSpacesLeft(idx);
        return idx;
    }

    public boolean isValidPartialMatch(String candidate) {
        boolean result = candidate.length() <= this.pattern.length();
        int i = 0;
        while (result && i < candidate.length()) {
            char cChar = candidate.charAt(i);
            char pChar = this.pattern.charAt(i);
            result = pChar == 'd' ? SegmentedString.isDigit(cChar) || cChar == ' ' : (pChar == '|' ? SegmentedString.isSeparator(cChar) && cChar == this.fields[i] : false);
            ++i;
        }
        return result;
    }

    public int replace(int from, int to, String value) {
        this.delete(from, to, false);
        int idx = this.insert(from, value);
        return idx;
    }

    public int shiftSpacesLeft(int index) {
        int delta = 0;
        int i = 0;
        while (i < this.fields.length - 1) {
            if (SegmentedString.isDigit(this.fields[i]) && this.fields[i + 1] == ' ' && this.pattern.charAt(i + 1) == 'd') {
                this.fields[i + 1] = this.fields[i];
                this.fields[i] = 32;
                if (index <= i + 1) {
                    ++delta;
                }
                if (i > 0) {
                    i -= 2;
                }
            }
            ++i;
        }
        return delta;
    }

    public String toString() {
        return String.valueOf(this.fields);
    }

    private int computeCursorPositionAfterDelete(int from, int to) {
        int sepIndex = -1;
        int i = to;
        while (i >= from) {
            if (this.pattern.charAt(i) == '|') {
                sepIndex = i;
            }
            --i;
        }
        return sepIndex != -1 ? sepIndex : to + 1;
    }

    private String createPattern(String format) {
        StringBuilder result = new StringBuilder(format.length());
        int i = 0;
        while (i < format.length()) {
            char fChar = format.charAt(i);
            if (this.isDigitPattern(fChar)) {
                result.append('d');
            } else if (SegmentedString.isSeparator(fChar)) {
                result.append('|');
            } else {
                throw new IllegalStateException("unsupported format character: " + fChar);
            }
            ++i;
        }
        return result.toString();
    }

    private int delete(int from, int to, boolean shift) {
        Assert.isLegal((from > -1 ? 1 : 0) != 0, (String)("'from' out of bounds: " + from));
        Assert.isLegal((from <= to ? 1 : 0) != 0, (String)String.format("'from' must be less-or-equal than 'to': %d, %d", from, to));
        Assert.isLegal((to < this.fields.length ? 1 : 0) != 0, (String)("'to' out of bounds: " + to));
        int i = from;
        while (i <= to) {
            if (this.pattern.charAt(i) != '|') {
                this.fields[i] = 32;
            }
            ++i;
        }
        int pos = this.computeCursorPositionAfterDelete(from, to);
        if (shift) {
            this.shiftSpacesLeft(to);
        }
        return pos;
    }

    private int findFreePosition(int index) {
        int pos;
        int result = -1;
        int n = pos = index < this.pattern.length() ? index : this.pattern.length() - 1;
        if (this.fields[pos] == ' ' && this.pattern.charAt(pos) == 'd') {
            result = pos;
        } else if (this.groupHasSpaceOnLeft(pos)) {
            this.shiftRight(index - 1);
            Assert.isLegal((this.fields[index - 1] == ' ' ? 1 : 0) != 0);
            result = index - 1;
        } else if (this.groupHasSpaceOnRight(pos)) {
            result = pos + 1;
        }
        return result;
    }

    private void shiftRight(int index) {
        int spacePos = -1;
        int pos = index;
        while (pos > -1 && spacePos == -1) {
            if (this.fields[pos] == ' ') {
                spacePos = pos;
                continue;
            }
            --pos;
        }
        String msg = String.format("did not find space in '%s' starting at %d", String.valueOf(this.fields), index);
        Assert.isLegal((spacePos != -1 ? 1 : 0) != 0, (String)msg);
        Assert.isLegal((this.fields[spacePos] == ' ' ? 1 : 0) != 0);
        int i = spacePos;
        while (i < index) {
            this.fields[i] = this.fields[i + 1];
            this.fields[i + 1] = 32;
            ++i;
        }
    }

    private boolean groupHasSpaceOnLeft(int index) {
        boolean result = false;
        int pos = index;
        while (pos > 0 && !result) {
            boolean bl = result = this.pattern.charAt(pos - 1) == 'd' && this.fields[pos - 1] == ' ';
            if (this.pattern.charAt(pos - 1) == '|') {
                pos = -1;
                continue;
            }
            --pos;
        }
        return result;
    }

    private boolean groupHasSpaceOnRight(int index) {
        return index < this.pattern.length() - 1 && this.pattern.charAt(index) == '|' && this.pattern.charAt(index + 1) == 'd' && this.fields[index + 1] == ' ';
    }

    private int insert(int index, char ch) {
        int freePosition;
        Assert.isLegal((index > -1 ? 1 : 0) != 0, (String)("index out of bounds: " + index));
        Assert.isLegal((index <= this.fields.length ? 1 : 0) != 0, (String)("index out of bounds: " + index));
        int result = index;
        if (index < this.fields.length) {
            int freePosition2;
            if (SegmentedString.isSeparator(ch) && SegmentedString.isSeparator(this.fields[index])) {
                result = index + 1;
            } else if (SegmentedString.isDigit(ch) && (freePosition2 = this.findFreePosition(index)) != -1) {
                this.fields[freePosition2] = ch;
                result = freePosition2 + 1;
            }
        } else if (index == this.fields.length && SegmentedString.isDigit(ch) && (freePosition = this.findFreePosition(index)) != -1) {
            this.fields[freePosition] = ch;
            result = freePosition + 1;
        }
        return result;
    }

    private boolean isDigitPattern(char fChar) {
        return "dMyHms".indexOf(fChar) != -1;
    }
}

