/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSelectableIndexedRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareMultipleSelectionObservableList;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareValidator;
import org.eclipse.riena.internal.ui.ridgets.swt.SortableComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.databinding.IUnboundPropertyObservable;
import org.eclipse.riena.ui.ridgets.databinding.UnboundPropertyWritableList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRidget
extends AbstractSelectableIndexedRidget
implements ITableRidget {
    private static final Listener eraseListener = new EraseListener();
    private final SelectionListener selectionTypeEnforcer = new SelectionTypeEnforcer();
    private final MouseListener doubleClickForwarder = new DoubleClickForwarder();
    private final ColumnSortListener sortListener = new ColumnSortListener();
    private ListenerList<IActionListener> doubleClickListeners;
    private DataBindingContext dbc;
    private TableViewer viewer;
    private String[] columnHeaders;
    private IObservableList rowObservables;
    private Class<?> rowBeanClass;
    private String[] renderingMethods;
    private boolean isSortedAscending = true;
    private int sortedColumn = -1;
    private final Map<Integer, Boolean> sortableColumnsMap = new HashMap<Integer, Boolean>();
    private final Map<Integer, Comparator<Object>> comparatorMap = new HashMap<Integer, Comparator<Object>>();
    private boolean moveableColumns;

    public TableRidget() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TableRidget.this.applyEraseListener();
            }
        });
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Table.class);
    }

    @Override
    protected void bindUIControl() {
        Table control = this.getUIControl();
        if (control != null && this.rowObservables != null) {
            this.checkColumns(control);
            this.viewer = new TableViewer(control);
            ObservableListContentProvider viewerCP = new ObservableListContentProvider();
            IObservableMap[] attrMap = BeansObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowBeanClass, (String[])this.renderingMethods);
            this.viewer.setLabelProvider((IBaseLabelProvider)new TableRidgetLabelProvider(attrMap));
            this.viewer.setContentProvider((IContentProvider)viewerCP);
            this.applyColumnsMoveable(control);
            this.applyTableColumnHeaders(control);
            this.applyComparator();
            this.applyEraseListener();
            this.viewer.setInput((Object)this.rowObservables);
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            this.dbc = new DataBindingContext();
            IViewerObservableValue viewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.viewer);
            this.dbc.bindValue((IObservableValue)viewerSelection, this.getSingleSelectionObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new OutputAwareValidator(this)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            OutputAwareMultipleSelectionObservableList viewerSelections = new OutputAwareMultipleSelectionObservableList(this.dbc.getValidationRealm(), (ISelectionProvider)this.viewer, Object.class, this);
            this.dbc.bindList((IObservableList)viewerSelections, this.getMultiSelectionObservable(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
            this.viewer.setSelection((ISelection)currentSelection);
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.addSelectionListener((SelectionListener)this.sortListener);
                ++n2;
            }
            control.addSelectionListener(this.selectionTypeEnforcer);
            control.addMouseListener(this.doubleClickForwarder);
        }
    }

    @Override
    protected void unbindUIControl() {
        Table control;
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
        if ((control = this.getUIControl()) != null) {
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.removeSelectionListener((SelectionListener)this.sortListener);
                ++n2;
            }
            control.removeSelectionListener(this.selectionTypeEnforcer);
            control.removeMouseListener(this.doubleClickForwarder);
            control.removeListener(40, eraseListener);
        }
        this.viewer = null;
    }

    @Override
    protected List<?> getRowObservables() {
        return this.rowObservables;
    }

    public Table getUIControl() {
        return (Table)super.getUIControl();
    }

    public void addDoubleClickListener(IActionListener listener) {
        Assert.isNotNull((Object)listener, (String)"listener is null");
        if (this.doubleClickListeners == null) {
            this.doubleClickListeners = new ListenerList(IActionListener.class);
        }
        this.doubleClickListeners.add((Object)listener);
    }

    public void bindToModel(IObservableList listObservableValue, Class<? extends Object> rowBeanClass, String[] columnPropertyNames, String[] columnHeaders) {
        if (columnHeaders != null) {
            String msg = "Mismatch between number of columnPropertyNames and columnHeaders";
            Assert.isLegal((columnPropertyNames.length == columnHeaders.length ? 1 : 0) != 0, (String)msg);
        }
        this.unbindUIControl();
        this.rowBeanClass = rowBeanClass;
        this.rowObservables = listObservableValue;
        this.renderingMethods = new String[columnPropertyNames.length];
        System.arraycopy(columnPropertyNames, 0, this.renderingMethods, 0, this.renderingMethods.length);
        if (columnHeaders != null) {
            this.columnHeaders = new String[columnHeaders.length];
            System.arraycopy(columnHeaders, 0, this.columnHeaders, 0, this.columnHeaders.length);
        } else {
            this.columnHeaders = null;
        }
        this.bindUIControl();
    }

    public void bindToModel(Object listBean, String listPropertyName, Class<? extends Object> rowBeanClass, String[] columnPropertyNames, String[] columnHeaders) {
        UnboundPropertyWritableList listObservableValue = new UnboundPropertyWritableList(listBean, listPropertyName);
        this.bindToModel((IObservableList)listObservableValue, rowBeanClass, columnPropertyNames, columnHeaders);
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.viewer != null) {
            this.viewer.getControl().setRedraw(false);
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            try {
                if (this.rowObservables instanceof IUnboundPropertyObservable) {
                    ((UnboundPropertyWritableList)this.rowObservables).updateFromBean();
                }
                this.viewer.refresh(true);
            }
            finally {
                this.viewer.setSelection((ISelection)currentSelection);
                this.viewer.getControl().setRedraw(true);
            }
        }
    }

    public IObservableList getObservableList() {
        return this.rowObservables;
    }

    public void removeDoubleClickListener(IActionListener listener) {
        if (this.doubleClickListeners != null) {
            this.doubleClickListeners.remove((Object)listener);
        }
    }

    public void setComparator(int columnIndex, Comparator<Object> compi) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        if (compi != null) {
            this.comparatorMap.put(key, compi);
        } else {
            this.comparatorMap.remove(key);
        }
        if (columnIndex == this.sortedColumn) {
            this.applyComparator();
        }
    }

    public int getSortedColumn() {
        TableColumn column;
        int result = -1;
        Table table = this.getUIControl();
        if (table != null && (column = table.getSortColumn()) != null) {
            result = table.indexOf(column);
        }
        return result;
    }

    public boolean isColumnSortable(int columnIndex) {
        this.checkColumnRange(columnIndex);
        boolean result = false;
        Integer key = columnIndex;
        Boolean sortable = this.sortableColumnsMap.get(columnIndex);
        if (sortable == null || Boolean.TRUE.equals(sortable)) {
            result = this.comparatorMap.get(key) != null;
        }
        return result;
    }

    public boolean isSortedAscending() {
        boolean result = false;
        Table table = this.getUIControl();
        if (table != null) {
            int sortDirection = table.getSortDirection();
            result = sortDirection == 128;
        }
        return result;
    }

    public void setColumnSortable(int columnIndex, boolean sortable) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        Boolean newValue = sortable;
        Boolean oldValue = this.sortableColumnsMap.put(key, newValue);
        if (oldValue == null) {
            oldValue = Boolean.TRUE;
        }
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("columnSortability", null, columnIndex);
        }
    }

    public void setSortedAscending(boolean ascending) {
        if (this.isSortedAscending != ascending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            this.applyComparator();
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    public void setSortedColumn(int columnIndex) {
        if (columnIndex != -1) {
            this.checkColumnRange(columnIndex);
        }
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.applyComparator();
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    @Override
    public int getSelectionIndex() {
        Table control = this.getUIControl();
        return control == null ? -1 : control.getSelectionIndex();
    }

    @Override
    public int[] getSelectionIndices() {
        Table control = this.getUIControl();
        return control == null ? new int[]{} : control.getSelectionIndices();
    }

    @Override
    public int indexOfOption(Object option) {
        Table control = this.getUIControl();
        if (control != null) {
            int optionCount = control.getItemCount();
            int i = 0;
            while (i < optionCount) {
                if (this.viewer.getElementAt(i).equals(option)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean hasMoveableColumns() {
        return this.moveableColumns;
    }

    public void setMoveableColumns(boolean moveableColumns) {
        if (this.moveableColumns != moveableColumns) {
            this.moveableColumns = moveableColumns;
            Table control = this.getUIControl();
            if (control != null) {
                this.applyColumnsMoveable(control);
            }
        }
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    private void applyColumnsMoveable(Table control) {
        TableColumn[] tableColumnArray = control.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setMoveable(this.moveableColumns);
            ++n2;
        }
    }

    private void applyComparator() {
        if (this.viewer != null) {
            Table table = this.viewer.getTable();
            Comparator<Object> compi = null;
            if (this.sortedColumn != -1) {
                Integer key = this.sortedColumn;
                compi = this.comparatorMap.get(key);
            }
            if (compi != null) {
                TableColumn column = table.getColumn(this.sortedColumn);
                table.setSortColumn(column);
                int direction = this.isSortedAscending ? 128 : 1024;
                table.setSortDirection(direction);
                SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, compi);
                this.viewer.setComparator((ViewerComparator)new TableComparator(sortableComparator));
            } else {
                this.viewer.setComparator(null);
                table.setSortColumn(null);
                table.setSortDirection(0);
            }
        }
    }

    private void applyEraseListener() {
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            control.removeListener(40, eraseListener);
            if (!this.isEnabled() && MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
                control.addListener(40, eraseListener);
            }
        }
    }

    private void applyTableColumnHeaders(Table control) {
        boolean headersVisible = this.columnHeaders != null;
        control.setHeaderVisible(headersVisible);
        if (headersVisible) {
            TableColumn[] columns = control.getColumns();
            int i = 0;
            while (i < columns.length) {
                String columnHeader = "";
                if (i < this.columnHeaders.length && this.columnHeaders[i] != null) {
                    columnHeader = this.columnHeaders[i];
                }
                columns[i].setText(columnHeader);
                ++i;
            }
        }
    }

    private void checkColumns(Table control) {
        int columnCount = control.getColumnCount() == 0 ? 1 : control.getColumnCount();
        String message = String.format("Table has %d columns, expected: %d", columnCount, this.renderingMethods.length);
        Assert.isLegal((columnCount == this.renderingMethods.length ? 1 : 0) != 0, (String)message);
    }

    private void checkColumnRange(int columnIndex) {
        Table table = this.getUIControl();
        int range = table.getColumnCount();
        String msg = "columnIndex out of range (0 - " + range + " ): " + columnIndex;
        Assert.isLegal((-1 < columnIndex ? 1 : 0) != 0, (String)msg);
        Assert.isLegal((columnIndex < range ? 1 : 0) != 0, (String)msg);
    }

    private final class ColumnSortListener
    extends SelectionAdapter {
        private ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            int columnIndex = column.getParent().indexOf(column);
            int direction = column.getParent().getSortDirection();
            if (columnIndex == TableRidget.this.sortedColumn) {
                if (direction == 128) {
                    TableRidget.this.setSortedAscending(false);
                } else if (direction == 1024) {
                    TableRidget.this.setSortedColumn(-1);
                }
            } else if (TableRidget.this.isColumnSortable(columnIndex)) {
                TableRidget.this.setSortedColumn(columnIndex);
                if (direction == 0) {
                    TableRidget.this.setSortedAscending(true);
                }
            }
            column.getParent().showSelection();
        }
    }

    private final class DoubleClickForwarder
    extends MouseAdapter {
        private DoubleClickForwarder() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (TableRidget.this.doubleClickListeners != null) {
                IActionListener[] iActionListenerArray = (IActionListener[])TableRidget.this.doubleClickListeners.getListeners();
                int n = iActionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IActionListener listener = iActionListenerArray[n2];
                    listener.callback();
                    ++n2;
                }
            }
        }
    }

    private static final class EraseListener
    implements Listener {
        private EraseListener() {
        }

        public void handleEvent(Event event) {
            event.detail &= 0xFFFFFFEF;
        }
    }

    private final class SelectionTypeEnforcer
    extends SelectionAdapter {
        private SelectionTypeEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            Table control;
            if (TableRidget.this.isOutputOnly()) {
                TableRidget.this.viewer.setSelection((ISelection)new StructuredSelection(TableRidget.this.getSelection()));
            } else if (ISelectableRidget.SelectionType.SINGLE.equals((Object)TableRidget.this.getSelectionType()) && (control = (Table)e.widget).getSelectionCount() > 1) {
                e.doit = false;
                control.setSelection(control.getSelectionIndex());
                Event event = new Event();
                event.type = 13;
                event.doit = true;
                control.notifyListeners(13, event);
            }
        }
    }
}

