/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeRidgetLabelProvider
extends TableRidgetLabelProvider
implements IColorProvider {
    private static final UpdateIconsTreeListener LISTENER = new UpdateIconsTreeListener();
    private final TreeViewer viewer;
    private final IObservableMap enablementAttribute;

    public static TreeRidgetLabelProvider createLabelProvider(TreeViewer viewer, Class<?> treeElementClass, IObservableSet knownElements, String[] valueAccessors, String enablementAccessor) {
        IObservableMap[] map = TreeRidgetLabelProvider.createAttributeMap(treeElementClass, knownElements, valueAccessors, enablementAccessor);
        return new TreeRidgetLabelProvider(viewer, map, enablementAccessor);
    }

    private static IObservableMap[] createAttributeMap(Class<?> treeElementClass, IObservableSet knownElements, String[] valueAccessors, String enablementAccessor) {
        IObservableMap[] result;
        if (enablementAccessor != null) {
            String[] attributes = new String[valueAccessors.length + 1];
            System.arraycopy(valueAccessors, 0, attributes, 0, attributes.length - 1);
            attributes[attributes.length - 1] = enablementAccessor;
            result = BeansObservables.observeMaps((IObservableSet)knownElements, treeElementClass, (String[])attributes);
        } else {
            result = BeansObservables.observeMaps((IObservableSet)knownElements, treeElementClass, (String[])valueAccessors);
        }
        return result;
    }

    private TreeRidgetLabelProvider(TreeViewer viewer, IObservableMap[] attributeMap, String enablementAccessor) {
        super(attributeMap);
        viewer.getTree().removeTreeListener((TreeListener)LISTENER);
        viewer.getTree().addTreeListener((TreeListener)LISTENER);
        this.enablementAttribute = this.findAttribute(attributeMap, enablementAccessor);
        this.viewer = viewer;
    }

    @Override
    public Image getImage(Object element) {
        String key = this.getImageKey(element);
        return Activator.getSharedImage(key);
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return super.getColumnImage(element, columnIndex);
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Object value;
        Color result = null;
        if (this.enablementAttribute != null && Boolean.FALSE.equals(value = this.enablementAttribute.get(element))) {
            result = this.viewer.getControl().getDisplay().getSystemColor(15);
        }
        return result;
    }

    private IObservableMap findAttribute(IObservableMap[] attributeMap, String enablementAccessor) {
        IObservableMap result = null;
        if (enablementAccessor != null) {
            int i = attributeMap.length - 1;
            while (result == null && i > -1) {
                String property;
                IObservableMap attribute = attributeMap[i];
                IBeanObservable beanObservable = (IBeanObservable)attribute;
                PropertyDescriptor pd = beanObservable.getPropertyDescriptor();
                String string = property = pd != null ? pd.getName() : null;
                if (enablementAccessor.equals(property)) {
                    result = attribute;
                }
                --i;
            }
        }
        return result;
    }

    private String getImageKey(Object element) {
        String result = "IMG_LEAF";
        if (this.viewer.isExpandable(element)) {
            boolean isExpanded = this.viewer.getExpandedState(element);
            result = isExpanded ? "IMG_NODE_EXPANDED" : "IMG_NODE_COLLAPSED";
        }
        return result;
    }

    private static final class UpdateIconsTreeListener
    implements TreeListener {
        private UpdateIconsTreeListener() {
        }

        public void treeCollapsed(TreeEvent e) {
            this.updateIcon((TreeItem)e.item, false);
        }

        public void treeExpanded(TreeEvent e) {
            this.updateIcon((TreeItem)e.item, true);
        }

        private void updateIcon(TreeItem item, boolean isExpanded) {
            String key = isExpanded ? "IMG_NODE_EXPANDED" : "IMG_NODE_COLLAPSED";
            Image image = Activator.getSharedImage(key);
            item.setImage(image);
        }
    }
}

